% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyModel.R
\name{identifyComponentModel}
\alias{identifyComponentModel}
\title{identifyComponentModel
Determine if a variance components model is identified}
\usage{
identifyComponentModel(..., verbose = TRUE)
}
\arguments{
\item{...}{Comma-separated relatedness component matrices representing the variance components of the model.}

\item{verbose}{logical. If FALSE, suppresses messages about identification; TRUE by default.}
}
\value{
A list of length 2 containing:
  \itemize{
    \item \code{identified}: TRUE if the model is identified, FALSE otherwise.
    \item \code{nidp}: A vector of non-identified parameters, specifying the names of components that are not simultaneously identified.
  }
}
\description{
identifyComponentModel
Determine if a variance components model is identified
}
\details{
This function checks the identification status of a given variance components model
by examining the rank of the concatenated matrices of the components.
If any components are not identified, their names are returned in the output.
}
\examples{

identifyComponentModel(A = list(matrix(1, 2, 2)), C = list(matrix(1, 2, 2)), E = diag(1, 2))

}
