% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_metadata_match_data}
\alias{BIEN_metadata_match_data}
\title{Check for differing records between old and new dataframes.}
\usage{
BIEN_metadata_match_data(old, new, return = "identical")
}
\arguments{
\item{old}{A dataframe that is to be compared to a (typically) newer dataframe.}

\item{new}{A dataframe that is to be compared to a (typically) older dataframe.}

\item{return}{What information should be returned?  Current options are: "identical" (Logical, are the two dataframes identical?), "additions" (numeric, which rows are new?), "deletions" (numeric, which rows are no longer present?), "logical" (logical, which elements of the old dataframe are in the new one?).}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Logical of varying length (depending on choice of "return" parameter)
}
\description{
BIEN_metadata_match_data compares old and new dataframes, and can check whether they are identical or be used to select rows that are unique to the old or new versions.
}
\note{
Since comparisons are done by row (except when using return="identical"), this function may fail to flag additions or deletions if they are exact duplicates of existing rows.
}
\examples{
\dontrun{
new<-BIEN_occurrence_species("Acer nigrum")
old<-new[-1:-4,]#simulate having an older dataset by removing four rows
BIEN_metadata_match_data(old,new,return="identical")
BIEN_metadata_match_data(old,new,return="additions")}
}
\seealso{
Other metadata functions: \code{\link{BIEN_metadata_citation}},
  \code{\link{BIEN_metadata_database_version}},
  \code{\link{BIEN_metadata_list_political_names}},
  \code{\link{BIEN_plot_metadata}},
  \code{\link{BIEN_ranges_list}}
}
