% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_stem_datasource}
\alias{BIEN_stem_datasource}
\title{Extract stem data for a given datasource from BIEN}
\usage{
BIEN_stem_datasource(datasource, cultivated = FALSE, only.new.world = TRUE,
  all.taxonomy = FALSE, native.status = FALSE, natives.only = TRUE,
  political.boundaries = FALSE, collection.info = F, all.metadata = F,
  ...)
}
\arguments{
\item{datasource}{A single datasource, or a vector of datasources.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{all.metadata}{Should additional plot metadata be returned?  Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing stem data for the specified datasource.
}
\description{
BIEN_stem_datasource downloads occurrence records for specific datasources from the BIEN database.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php

Setting either "cultivated" or "native.status" to TRUE will significantly slow the speed of a query.

#' @note For a list of available datasources, use \code{\link{BIEN_plot_list_datasource}}.
}
\examples{
\dontrun{
BIEN_stem_datasource(datasource = "SALVIAS")}
}
\seealso{
Other stem functions: \code{\link{BIEN_stem_family}},
  \code{\link{BIEN_stem_genus}},
  \code{\link{BIEN_stem_sampling_protocol}},
  \code{\link{BIEN_stem_species}}
}
