% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{generateData}
\alias{generateData}
\title{Generate data from parameters of marginal monotherapy model}
\usage{
generateData(pars, sigma, data = NULL, transforms = NULL,
  null_model = c("loewe", "hsa", "bliss"), error = 1,
  sampling_errors = NULL, wild_bootstrap = FALSE, ...)
}
\arguments{
\item{pars}{Coefficients of the marginal model along with their appropriate
naming scheme. These will typically be estimated using
\code{\link{fitMarginals}}. Futhermore, \code{pars} can simply be a
\code{MarginalFit} object and \code{transforms} object will be
automatically extracted.}

\item{sigma}{Standard deviation to use for randomly generated error terms. This
argument is unused if \code{error = 4} so that sampling error vector is
provided.}

\item{data}{Data frame with dose columns \code{("d1", "d2")} to generate the
effect for. Only \code{"d1"} and \code{"d2"} columns of the dose-response
dataframe should be passed to this argument. \code{"effect"} column should
not be passed and if it is, the column will be replaced by simulated data.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{null_model}{Specified null model for the expected response surface.
Currently, allowed options are \code{"loewe"} for generalized Loewe model,
and \code{"hsa"} for Highest Single Agent model.}

\item{error}{Type of error for resampling. \code{error = 1} (Default) adds
normal errors to the simulated effects, \code{error = 2} adds errors sampled
from a mixture of two normal distributions, \code{error = 3} generates errors
from a rescaled chi-square distribution. \code{error = 4} will use bootstrap.
Choosing this option, the error terms will be resampled from the vector
specified in \code{sampling_errors}.}

\item{sampling_errors}{Sampling vector to resample errors from. Used only if
\code{error = 4}.}

\item{wild_bootstrap}{Whether special bootstrap to correct for
heteroskedasticity should be used. If \code{wild_bootstrap = TRUE}, errors
are generated from \code{sampling_errors} multiplied by a random variable
following Rademacher distribution. Argument is used only if \code{error = 4}.}

\item{...}{Further arguments}
}
\value{
Dose-response dataframe with generated data including \code{"effect"}
  as well as \code{"d1"} and \code{"d2"} columns.
}
\description{
This function is used to generate data for bootstrapping of the null
distribution for various estimates. Optional arguments such as specific
choice of sampling vector or corrections for heteroskedasticity can be
specified in the function arguments.
}
\examples{
  coefs <- c("h1" = 1, "h2" = 1.5, "b" = 0,
             "m1" = 1, "m2" = 2, "e1" = 0.5, "e2" = 0.1)

  ## Dose levels are set to be integers from 0 to 10
  generateData(coefs, sigma = 1)

  ## Dose levels are taken from existing dataset with d1 and d2 columns
  data <- subset(directAntivirals, experiment == 1)
  generateData(data = data[, c("d1", "d2")], pars = coefs, sigma = 1)
}
