% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{hist.BMRMM}
\alias{hist.BMRMM}
\title{Histogram of Duration Times}
\usage{
\method{hist}{BMRMM}(
  x,
  comp = NULL,
  xlim = NULL,
  breaks = NULL,
  main = NULL,
  col = "gray",
  xlab = "Duration times",
  ylab = "Density",
  ...
)
}
\arguments{
\item{x}{an object of class \code{BMRMM}.}

\item{comp}{one of
\itemize{
\item \code{NULL}, which means the histogram for all duration times is plotted with the posterior mean mixture gamma distribution. Default option.
\item an integer specifying the mixture component for which the corresponding histogram is plotted with mixture gamma parameters taken from the last MCMC iteration.
}}

\item{xlim}{a range of x values with sensible defaults. Default is \code{NULL}, which is to use \code{c(min(duration), max(duration))}.}

\item{breaks}{an integer giving the number of cells for the histogram. Default is \code{NULL}, which is to use the Freedman-Diaconis rule, i.e., \code{(max(duration)-min(duration))*n^(1/3)/2/IQR(duration)}.}

\item{main}{main title. Default is \code{NULL}, which is to use \code{"Histogram with Posterior Mean"} when \code{comp} is \code{NULL} and \code{"Component X"} if \code{comp} is specified.}

\item{col}{color of the histogram bars. Default is \code{gray}.}

\item{xlab}{x-axis label. Default is \code{"Duration times"}.}

\item{ylab}{y-axis label. Default is \code{"Density"}.}

\item{...}{further arguments for the hist function.}
}
\value{
An object of class \code{histogram}.
}
\description{
Plots the histogram of duration times in two ways as the users desire:
\enumerate{
\item Histogram of all duration times superimposed the posterior mean mixture gamma distribution;
\item Histogram of a specified mixture component superimposed the gamma distribution with shape and rate
parameters taken from the last MCMC iteration.
}
}
\examples{
results <- BMRMM(foxp2sm, num.cov = 2, simsize = 50, 
                 duration.distr = list('mixgamma',shape=rep(1,3),rate=rep(1,3)))

# plot the histogram of all duration times superimposed with 
# the posterior mixture gamma distribution
hist(results, xlim = c(0, 1), breaks = 50)

# plot the histogram for components 1 superimposed with 
# the mixture gamma distribution of the last MCMC iteration
hist(results, components = 1)

}
