% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMORS.R
\name{BMORS}
\alias{BMORS}
\title{Bayesian Multi-Output Regression Stacking (BMORS)}
\usage{
BMORS(Y = NULL, ETA = NULL, covModel = "BRR",
  predictor_Sec_complete = FALSE, nIter = 2500, burnIn = 500,
  thin = 5, progressBar = TRUE, testingSet = NULL,
  parallelCores = 1, digits = 4)
}
\arguments{
\item{Y}{\code{(matrix)} Phenotypic response where each column is a different trait}

\item{ETA}{\code{(matrix)} This is a two-level list used to specify the regression function (or linear predictor).}

\item{covModel}{\code{(string)} Name of the covariates model to implement (BRR, BayesA, BayesB, BayesC).}

\item{predictor_Sec_complete}{FALSE by default}

\item{nIter}{\code{(integer)} Number of iterations to fit the model.}

\item{burnIn}{\code{(integer)} Number of items to burn at the beginning of the model.}

\item{thin}{\code{(integer)} Number of items to thin the model.}

\item{progressBar}{\code{(Logical)} Show the progress bar.}

\item{testingSet}{\code{(object or vector)} Crossvalidation object or vector with the positions to use like testing in a cross-validation test.}

\item{parallelCores}{\code{(integer)} Number of cores to use.}

\item{digits}{\code{(integer)} Number of digits of accuracy in the results.}
}
\description{
Bayesian Multi-Output Regression Stacking (BMORS)
}
\examples{
\donttest{
data("WheatToy")
phenoWheatToy <- phenoWheatToy[order(phenoWheatToy$Env, phenoWheatToy$Gid),]

#Matrix Design
LG <- cholesky(genoWheatToy)
ZG <- model.matrix(~0 + as.factor(phenoWheatToy$Gid))
Z.G <- ZG \%*\% LG

#Linear Predictor
ETA <- list(Gen = list(X = Z.G, model = 'BRR'))

pheno <- phenoWheatToy[, c(1:3)] #Use only the first trait to do a cv
colnames(pheno) <- c('Line', 'Env', 'Response')
CrossValidation <- CV.RandomPart(pheno, NPartitions = 10, PTesting = 0.2, set_seed = 123)

#Pheno
Y <- as.matrix(phenoWheatToy[, c(3,4)])
#Check predictive capacities of the model
pm <- BMORS(Y, ETA = ETA, nIter = 10000, burnIn = 5000, thin = 2,
            testingSet = CrossValidation,  digits = 4)
}
}
