## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ------------------------------------------------------------------------
library(BMTME)
data('WheatMadaToy')

## ---- echo=FALSE---------------------------------------------------------
knitr::kable(head(phenoMada))

## ------------------------------------------------------------------------
phenoMada <- (phenoMada[order(phenoMada$GID),])

## ------------------------------------------------------------------------
LG <- cholesky(genoMada)
ZG <- model.matrix(~0 + as.factor(phenoMada$GID))
Z.G <- ZG %*% LG

## ------------------------------------------------------------------------
Y <- as.matrix(phenoMada[, -c(1)])

## ------------------------------------------------------------------------
fm <- BME(Y = Y, Z1 = Z.G, nIter = 1250, burnIn = 500, thin = 2, bs = 50)
fm

## ------------------------------------------------------------------------
str(fm)

## ------------------------------------------------------------------------
COV_TraitGenetic <- fm$varTrait
COV_TraitGenetic

## ------------------------------------------------------------------------
COR_TraitGenetic <- cov2cor(COV_TraitGenetic)
COR_TraitGenetic

## ------------------------------------------------------------------------
COV_ResGenetic <- fm$vare
COV_ResGenetic

## ------------------------------------------------------------------------
COR_ResGenetic <- cov2cor(COV_ResGenetic)
COR_ResGenetic

## ------------------------------------------------------------------------
head(fm$yHat)

## ------------------------------------------------------------------------
plot(fm, trait = 'PH')

## ------------------------------------------------------------------------
pheno <- data.frame(GID = phenoMada[, 1], Env = '', Response = phenoMada[, 3])

## ------------------------------------------------------------------------
CrossV <- CV.RandomPart(pheno, NPartitions = 4, PTesting = 0.2, set_seed = 123)

## ------------------------------------------------------------------------
pm <- BME(Y = Y, Z1 = Z.G, nIter = 1000, burnIn = 500, thin = 2, bs = 50,
          testingSet = CrossV, progressBar = FALSE)
summary(pm)

## ------------------------------------------------------------------------
boxplot(pm)

## ------------------------------------------------------------------------
boxplot(pm, select = 'MAAPE')

