% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multMixNRMI.R
\name{plot.multNRMI}
\alias{plot.multNRMI}
\title{Plot the density estimate and the 95\% credible interval}
\usage{
\method{plot}{multNRMI}(x, ...)
}
\arguments{
\item{x}{An object of class multNRMI}

\item{...}{Further arguments to be passed to generic functions, ignored at the moment}
}
\value{
A graph with the density estimate, the 95\% credible interval.
Includes a histogram if the data is non censored.
}
\description{
The density estimate is the mean posterior density computed on the data
points.
}
\examples{
\donttest{
data(salinity)
fit <- multMixNRMI2cens(salinity$left, salinity$right, parallel = TRUE, Nit = 10, ncores = 2)
plot(fit)
}
}
