\name{get.oc}
\alias{get.oc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Generate operating characteristics
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Obtain the operating characteristics of the BOIN design by simulating trials. 
}
\usage{
get.oc(target, p.true, ncohort, cohortsize, startdose = 1, p.saf = "default", 
p.tox = "default",  design = 1, cutoff.eli = 0.95, extrasafe = FALSE, 
offset = 0.05, ntrial = 1000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{target}{
%%     ~~Describe \code{target} here~~
target toxicity rate
}
  \item{p.true}{
%%     ~~Describe \code{p.true} here~~
a vector containing the true toxicity probabilities of the investigational dose levels.
}
  \item{ncohort}{
%%     ~~Describe \code{ncohort} here~~
the total number of cohorts
}
  \item{cohortsize}{
%%     ~~Describe \code{cohortsize} here~~
the cohort size
}
  \item{startdose}{
%%     ~~Describe \code{startdose} here~~
the starting dose level for the trial
}
  \item{p.saf}{
%%     ~~Describe \code{p.saf} here~~
the highest toxicity probability that is deemed subtherapeutic (i.e. below the MTD) such that dose escalation should be made.The default value is \code{p.saf=0.6xtarget}.}
  \item{p.tox}{
%%     ~~Describe \code{p.tox} here~~
the loweset toxicity probability that is deemed overly toxic such that deescalation is required. The default value is \code{p.tox=1.4xtarget}.
}
  \item{design}{
%%     ~~Describe \code{design} here~~
to use the local optimal design (the default, \code{design=1}) or the global optimal design (\code{design=2}).
}
  \item{cutoff.eli}{
%%     ~~Describe \code{cutoff.eli} here~~
the cutoff to eliminate the overly toxic dose for safety. We recommend the default value of \code{(cutoff.eli=0.95)} for general use 
}
  \item{extrasafe}{
%%     ~~Describe \code{ntrial} here~~
set \code{extrasafe=TRUE} to impose a more stringent stopping rule
}
  \item{offset}{
%%     ~~Describe \code{ntrial} here~~
a small positive number (between 0 and 0.5) to control how strict the stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a more strict stopping rule. The default value \code{offset=0.05} generally works well.
}
  \item{ntrial}{
%%     ~~Describe \code{ntrial} here~~
the total number of trials to be simulated. 
}
}
\details{
The operating characteristics of the BOIN design are generated by simulating trials under the prespecified  true toxicity probabilities of the investigational doses. The BOIN design has a built-in stopping rule, i.e., stop the trial if the lowest dose is eliminated due to toxicity. For some applications, investigators may prefer a more strict stopping rule for extra safety when the lowest dose is overly toxic. Setting \code{extrasafe=TRUE} imposes the following more strict stopping rule: stop the trial if (1) the number of patients treated at the lowest dose >=3, and (2) Pr(toxicity rate of the lowest dose > \code{target} | data) > \code{cutoff.eli-offset}. As a tradeoff, the strong stopping rule will decrease the selection percentage of the MTD when the lowest dose actually is the MTD.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
\code{get.oc} returns the operating characteristics of the BOIN design, including (1) selection percentage at each dose level, (2) the number of patients treated at each dose level, (3) the number of toxicity observed at each dose level, (4) the average number of toxicities, (5) the average number of patients, (6) the risk of poor allocation and (7) the risk of toxicity.
}

\references{
%% ~put references to the literature/web site here ~
Liu S. and Yuan, Y. (2014). Bayesian Optimal Interval Designs for Phase I Clinical Trials, \emph{Journal of the Royal Statistical Society: Series C}, to appear
}

\author{
Suyu Liu and Ying Yuan (yyuan@mdanderson.org)
}

\note{
%%  ~~further notes~~
We recommend to use the local BOIN design (i.e., the default option) because of its better operating characteristics and simplicity. We should avoid setting the values of \code{p.saf} and \code{p.tox} very close to \code{target}. This is because the small sample sizes of typical phase I trials prevent us from differentiating the target toxicity rate from the rates close to it. In addition, in most clinical applications, the target toxicity rate is often a rough guess, and finding a dose level with a toxicity rate reasonably close to the target rate will still prove to be of interest to the investigator. The default values provided by \code{get.boundary} are generally reasonable for most clinical applications.  
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software_release/OptInterval/tutorial.pdf}

Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software_release/OptInterval/paper.pdf}
}

\examples{
## Consider a phase I trial aiming to find the MTD with a target toxicity rate of 0.3 
## the maximum sample size is 30 patients in cohort size of 3
## assume the true toxicity rates of 5 doses are (0.05, 0.15, 0.3, 0.45, 0.6)
## run 1,000 simulated trials
ptox = c(0.05, 0.15, 0.3, 0.45, 0.6)
get.oc(target=0.3, p.true=ptox, ncohort=10, cohortsize=3, ntrial=1000)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ operating characteristics }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
