% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.mtd.R
\name{select.mtd}
\alias{select.mtd}
\title{Select the maximum tolerated dose (MTD) for single agent trials}
\usage{
select.mtd(target, npts, ntox, cutoff.eli=0.95, extrasafe=FALSE, offset=0.05, print=TRUE)
}
\arguments{
\item{target}{the target toxicity rate}

\item{npts}{a vector containing the number of patients treated at each dose level}

\item{ntox}{a vector containing the number of patients who experienced dose-limiting
toxicity at each dose level}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of (\code{cutoff.eli=0.95}) for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more strict stopping rule for
extra safety}

\item{offset}{a small positive number (between 0 and 0.5) to control how strict the
stopping rule is when \code{extrasafe=TRUE}. A larger value leads to
a more strict stopping rule. The default value \code{offset=0.05}
generally works well.}

\item{print}{to print out the dose selection result}
}
\value{
\code{select.mtd()} returns the MTD based on the trial data.
}
\description{
Select the maximum tolerated dose (MTD) when the single-agent trial is completed
}
\details{
\code{select.mtd()} selects the MTD based on isotonic estimates of toxicity
         probabilities. \code{select.mtd} selects as the MTD dose j*, for which the
         isotonic estimate of the toxicity rate is closest to the target. If there
         are ties, we select from the ties the highest dose level when the estimate
         of the toxicity rate is smaller than the target, or the lowest dose level
         when the estimate of the toxicity rate is greater than the target. The
         isotonic estimates are obtained by the pooled-adjacent-violators algorithm
         (PAVA) (Barlow, 1972).
}
\note{
The MTD selection and dose escalation/deescalation rule are two independent
       components of the trial design. When appropriate, another dose selection
       procedure (e.g., based on a fitted logistic model) can be used to select
       the MTD after the completion of the trial using the BOIN design.
}
\examples{
n<-c(3, 3, 15, 9, 0)
y<-c(0, 0, 4, 4, 0)
select.mtd(target=0.3, npts=n, ntox=y)

}
\author{
Suyu Liu and Ying Yuan
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for
           Phase I Clinical Trials, Journal of the Royal Statistical Society:
           Series C, 64, 507-523.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.2_tutorial.pdf}

Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

