% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BRINDA.R
\name{BRINDA}
\alias{BRINDA}
\title{Computation of BRINDA Adjusted Micronutrient Biomarkers for inflammation}
\usage{
BRINDA(
  dataset,
  retinol_binding_protein_varname,
  retinol_varname,
  ferritin_varname,
  soluble_transferrin_receptor_varname,
  zinc_varname,
  crp_varname,
  agp_varname,
  population_group,
  crp_ref_value_manual = NULL,
  agp_ref_value_manual = NULL,
  output_format
)
}
\arguments{
\item{dataset}{Enter the name of the dataset (should be already loaded in the
R environment; micronutrient biomarkers should NOT be log-transformed).}

\item{retinol_binding_protein_varname}{Enter the variable name of retinol
binding protein (if available) in your dataset. The variable can be in either
international or conventional units. The adjusted values in the output
dataset will be in the same unit as retinol binding protein variable in the
input dataset.}

\item{retinol_varname}{Enter the variable name of serum/plasma retinol
(if available) in your dataset. The variable can be in either international
or conventional units. The adjusted values in the output dataset will be in
the same unit as retinol variable in the input dataset.}

\item{ferritin_varname}{Enter the variable name of serum/plasma ferritin
(if available) in your dataset. The variable can be in either international
or conventional units. The adjusted values in the output dataset will be in
the same unit as serum ferritin in the input dataset.}

\item{soluble_transferrin_receptor_varname}{Enter the variable name of
serum/plasma soluble transferrin receptor (if available) in your dataset.
The variable can be in either international or conventional units.
The adjusted values in the output dataset will be in the same unit as soluble
transferrin receptor in the input dataset.}

\item{zinc_varname}{Enter the variable name of serum/plasma zinc
(if available) in your dataset. The variable can be in either international
or conventional units. The adjusted values in the output dataset will be in
the same unit as serum zinc in the input dataset.}

\item{crp_varname}{Enter the variable name of CRP (if available) in your
dataset. Unit must be mg/L}

\item{agp_varname}{Enter the variable name of AGP (if available)  in your
dataset (unit must be g/L)}

\item{population_group}{Please write WRA, PSC, Other, or Manual. The BRINDA R
package can only analyze one population group at one time.
If users select WRA or PSC, external CRP/AGP reference values will be used
If users select Other, the lowest decile of the CRP and AGP will be
calculated and used as CRP and AGP reference values
If users select Manual as the population group, users can define their own
AGP and CRP reference values for the BRINDA adjustment.}

\item{crp_ref_value_manual}{Leave it empty if users select population_group
as WRA, PSC, or Other. If users select population_group as Manual,
and there is a CRP variable in the dataset, enter a user-specified CRP
reference value}

\item{agp_ref_value_manual}{Leave it empty if users select population_group
as WRA, PSC, or Other If users select population_group as Manual, and there
is an AGP variable in the dataset, enter a user specified AGP reference value}

\item{output_format}{Please write FULL or SIMPLE (SIMPLE by default if users
leave it empty). The SIMPLE output only provides users adjusted micronutrient
biomarker values. The FULL output provides users all the intermediate
parameters for the BRINDA adjustment, such as coefficients of log (AGP) and
log (CRP) and associated standard errors and P values, in addition to adjusted
micronutrient biomarker values.}
}
\value{
`brinda()` returns a data frame object that contains additional
variables of adjusted micronutrient biomarkers (by default). If users specify
output format = full, the output dataset will also include additional
variables such as coefficients of regressions of micronutrient biomarkers on
AGP and CRP, natural logs of AGP/CRP reference values.
}
\description{
Inflammation can affect many micronutrient biomarkers and can thus lead to incorrect diagnosis of individuals and to over- or under-estimate the prevalence of deficiency in a population. Biomarkers Reflecting Inflammation and Nutritional Determinants of Anemia (BRINDA) is a multi-agency and multi-country partnership designed to improve the interpretation of nutrient biomarkers in settings of inflammation and to generate context-specific estimates of risk factors for anemia (Suchdev (2016) <doi:10.3945/an.115.010215>). In the past few years, BRINDA published a series of papers to provide guidance on how to adjust micronutrient biomarkers, retinol binding protein, serum retinol, serum ferritin by Namaste (2020), soluble transferrin receptor (sTfR), serum zinc, serum and Red Blood Cell (RBC) folate, and serum B-12, using inflammation markers, alpha-1-acid glycoprotein (AGP) and/or C-Reactive Protein (CRP) by Namaste (2020) <doi:10.1093/ajcn/nqaa141>, Rohner (2017) <doi:10.3945/ajcn.116.142232>, McDonald (2020) <doi:10.1093/ajcn/nqz304>, and Young (2020) <doi:10.1093/ajcn/nqz303>. The BRINDA inflammation adjustment method mainly focuses on Women of Reproductive Age (WRA) and Preschool-age Children (PSC); however, the general principle of the BRINDA method might apply to other population groups. The BRINDA R package is a user-friendly all-in-one R package that uses a series of functions to implement BRINDA adjustment method, as described above. The BRINDA R package will first carry out rigorous checks and provides users guidance to correct data or input errors (if they occur) prior to inflammation adjustments. After no errors are detected, the package implements the BRINDA inflammation adjustment for up to five micronutrient biomarkers, namely retinol-binding-protein, serum retinol, serum ferritin, sTfR, and serum zinc (when appropriate), using inflammation indicators of AGP and/or CRP for various population groups. Of note, adjustment for serum and RBC folate and serum B-12 is not included in the R package, since evidence shows that no adjustment is needed for these micronutrient biomarkers in either WRA or PSC groups (Young (2020) <doi:10.1093/ajcn/nqz303>).
}
\examples{
data(sample_data)

# Example 1
# Calculate BRINDA inflammation adjustment values for preschool-age children
# (Assuming the data set contains information of preschool-age children)

sample_data_adj <-
    BRINDA(dataset = sample_data,
       retinol_binding_protein_varname = rbp,
       retinol_varname = sr,
       ferritin_varname = sf,
       soluble_transferrin_receptor_varname = stfr,
       zinc_varname = zinc,
       crp_varname = crp,
       agp_varname = agp,
       population = Psc,
       crp_ref_value_manual = ,
       agp_ref_value_manual = ,
       output_format = )

# Example 2
# Calculate BRINDA inflammation adjustment values for non-pregnant women of
# reproductive age assuming the sample data set contains information of women
# of reproductive age).

sample_data_adj2 <-
    BRINDA(dataset = sample_data,
       retinol_binding_protein_varname = rbp,
       retinol_varname = sr,
       ferritin_varname = sf,
       soluble_transferrin_receptor_varname = stfr,
       zinc_varname = zinc,
       crp_varname = ,
       agp_varname = agp, population = WRA,
       crp_ref_value_manual = ,
       agp_ref_value_manual = ,
       output_format = )

# Example 3
# Calculate BRINDA inflammation adjustment values for other population assuming
# the study population is neither women of reproductive age nor preschool-age
# children

sample_data_adj3 <-
    BRINDA(dataset = sample_data,
       retinol_binding_protein_varname = rbp,
       retinol_varname = sr,
       ferritin_varname = sf,
       soluble_transferrin_receptor_varname = stfr,
       zinc_varname = zinc,
       crp_varname = crp,
       agp_varname = ,
       population = OTHER,
       crp_ref_value_manual = ,
       agp_ref_value_manual = ,
       output_format = FULL)

# Example 4
# Calculate BRINDA inflammation adjustment values for a population when users
# would like to apply user-defined CRP and AGP reference values

sample_data_adj4 <-
    BRINDA(dataset = sample_data,
       retinol_binding_protein_varname = rbp,
       retinol_varname = sr,
       ferritin_varname = sf,
       soluble_transferrin_receptor_varname = stfr,
       zinc_varname = zinc,
       crp_varname = crp,
       agp_varname = agp,
       population = MANUAL,
       crp_ref_value_manual = 0.2,
       agp_ref_value_manual = 1.4,
       output_format = FULL)

}
\author{
Hanqi Luo, O.Yaw Addo, Afrin Jahan
}
