% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Family}
\alias{Family}
\title{Size of family versus cost per person per week for groceries}
\format{A data frame/tibble with 20 observations on two variables
\describe{ 
\item{number}{number in family} 
\item{cost}{cost per person (in dollars)} 
}}
\usage{
Family
}
\description{
Data for Exercise 2.89
}
\examples{

plot(cost ~ number, data = Family)
abline(lm(cost ~ number, data = Family), col = "red")
cor(Family$cost, Family$number)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Family, aes(x = number, y = cost)) + 
           geom_point() + 
           geom_smooth(method = "lm") + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
