% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/92_coef.R
\name{coef.bvar}
\alias{coef.bvar}
\alias{vcov.bvar}
\alias{print.bvar_coefs}
\alias{print.bvar_vcovs}
\title{Coefficient and VCOV methods for Bayesian VARs}
\usage{
\method{coef}{bvar}(object, conf_bands = 0.5, comp = FALSE, ...)

\method{vcov}{bvar}(object, conf_bands = 0.5, ...)

\method{print}{bvar_coefs}(x, digits = 3L, complete = FALSE, ...)

\method{print}{bvar_vcovs}(x, digits = 3L, complete = FALSE, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{conf_bands}{Numeric vector of desired confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. 0.5 is always included.}

\item{comp}{Logical scalar. Whether to retrieve the companion matrix of
coefficients. See \code{\link{companion.bvar}}.}

\item{...}{Not used.}

\item{x}{Object of class \code{bvar_coefs} / \code{bvar_vcovs}.}

\item{digits}{Integer scalar. Fed to \code{\link[base]{round}} and applied
to numeric outputs (i.e. the quantiles).}

\item{complete}{Logical scalar. Whether to print only medians or all
available confidence bands.}
}
\value{
Returns a numeric array of class \code{bvar_coefs} /
\code{bvar_vcovs} with desired values at the specified confidence bands.
}
\description{
Retrieves coefficient / VCOV values for Bayesian VARs generated via
\code{\link{bvar}}.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Get coefficent values at the 10\%, 50\% and 90\% quantiles
coef(x, conf_bands = 0.10)

# Only get the median of the variance-covariance matrix
vcov(x, conf_bands = 0.5)
}
}
\seealso{
\code{\link{bvar}}
}
