% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_metropolis_setup.R, R/35_metropolis_print.R
\name{bv_metropolis}
\alias{bv_metropolis}
\alias{bv_mh}
\alias{print.bv_metropolis}
\title{Metropolis-Hastings settings}
\usage{
bv_metropolis(scale_hess = 0.01, adjust_acc = FALSE,
  acc_lower = 0.25, acc_upper = 0.35, acc_change = 0.01)

bv_mh(scale_hess = 0.01, adjust_acc = FALSE, acc_lower = 0.25,
  acc_upper = 0.35, acc_change = 0.01)

\method{print}{bv_metropolis}(x, ...)
}
\arguments{
\item{scale_hess}{Numeric scalar or vector. Scaling parameter, determining
the range of hyperparameter draws. \strong{Should be calibrated so a
reasonable rate of acceptance is reached}. If provided as vector the length
must equal the number of hyperparameters (one per variable for \code{psi}).}

\item{adjust_acc}{Logical scalar. Whether or not to further scale the
variability of parameter draws during the burn-in phase.}

\item{acc_lower, acc_upper}{Numeric scalar. Lower (upper) bound of the target
acceptance rate. Required if \emph{adjust_acc} is set to \code{TRUE}.}

\item{acc_change}{Numeric scalar. Percent change applied to the Hessian
matrix. Required if \emph{adjust_acc} is set to \code{TRUE}.}

\item{x}{An object of class \code{bv_metropolis}.}

\item{...}{Not used}
}
\value{
Returns a named list of class \code{bv_metropolis} with options for
\code{\link{bvar}}.
}
\description{
Function to provide settings for the Metropolis-Hastings step in
\code{\link{bvar}}. Options include scaling the inverse Hessian that
is used to draw parameter proposals and automatic scaling to
achieve a certain acceptance rate.
}
\examples{
# Only adjust the scale parameter
bv_mh(scale_hess = 10)

# Turn on automatic scaling of the acceptance rate to [20\%, 40\%]
bv_mh(adjust_acc = TRUE, acc_lower = 0.2, acc_upper = 0.4)

# Increase the rate of automatic scaling
bv_mh(adjust_acc = TRUE, acc_lower = 0.2, acc_upper = 0.4, acc_change = 0.1)
}
\keyword{BVAR}
\keyword{MH}
\keyword{VAR}
\keyword{acceptance}
\keyword{mcmc}
\keyword{metropolis-hastings}
