% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/94_logLik.R
\name{logLik.bvar}
\alias{logLik.bvar}
\title{Log-Likelihood method for Bayesian VARs}
\usage{
\method{logLik}{bvar}(object, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{...}{Not used.}
}
\value{
Returns an object of class \code{logLik}.
}
\description{
Calculates the log-likelihood of Bayesian VAR models generated with
\code{\link{bvar}}.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Calculate the log-likelihood
logLik(x)
}
}
\seealso{
\code{\link{bvar}}
}
\keyword{BVAR}
\keyword{analysis}
