fitBVS <- function(Z,data,forced=NULL,cov=NULL,a1=NULL,rare=FALSE,hap=FALSE,inform=FALSE,which=NULL,models.char=NULL){
	    case = names(data)[1]
	    p = dim(data)[2] - 1
	    n = dim(data)[1]
	    pgamma = sum(Z!=0)
	    coef = rep(0,p)
	    a0 = qnorm((1-2^(-1/p)))
	    which.ind = 1:p
	    if(rare==TRUE){
	    	coef=0
	    	which.ind=1}
	    predictors = c(names(forced),colnames(data[,-1])[Z>0])	
	    data.i = data
	    q = dim(cov)[2]
	    if(length(cov)==0){q=1}
	    
	    	
	    ##Check if sampled new model already exists in which matrix
	    new.model.ind = c(1:length(models.char))[models.char==paste(Z,collapse="")]
	    
	    ##If sampled model already exists get the results from which
	    if(length(new.model.ind)>0){
	    	results.new = which[new.model.ind[1],][-c(1:p)]
	    	coef = results.new[which.ind]
	    	a1.old = results.new[-which.ind][1:q]
	    	fitness.old = results.new[-which.ind][q+1]
	    	PrM.old = results.new[-which.ind][q+2] 
	        ll = fitness.old + log(PrM.old)
	    }
	    
	    ##If sampled model does not already exist	
	    if(length(new.model.ind)==0){	
	      ##If we are doing an analysis with rare variants make risk index and new predict vector
	      if(rare == TRUE & pgamma>0){
	    	  coef = 0
	    	  risk.index = as.matrix(data[,-1])%*%as.numeric(Z)
	    	  data.i = cbind(data,risk.index)
	    	  predictors=c(names(forced),"risk.index")}
	    	  
	      ##If we are doing a haplotype analysis estimate haplotypes and new predict vector
	      if(hap==TRUE & pgamma>1){
	          G <- data[, colnames(data[,-1])[Z>0]]
			  X.haps = hapBVS(G,min.Hap.freq=.02)
			  data.i <- cbind(data, X.haps)
			  predictors = c(names(forced),names(X.haps))
	        }
	    
	      ##Attach forced variables to data matrix  	
	      if(length(forced)>0){
	          data.i = cbind(data.i,forced)}   
	      
	        
	      ##Make fmla formula for glm    
	      if(length(predictors)==0){
	    	  fmla = as.formula(paste(case,"~1",sep=""))}
	      if(length(predictors)>0){
	          fmla = as.formula(paste(case,"~",paste(predictors,collapse="+")))}
	        
	      ##Fit glm
	      fit = suppressWarnings(glm(fmla,data = data.i,family="binomial"))
	      
	      
	      ##Calculate Log Likelihood
	      penalty = length(predictors) - length(forced)
	      ll = (deviance(fit) + penalty*2)/2
	    
	      ##Calculate coef. vector
	      if((rare==FALSE & hap==FALSE)){
	          coef[Z!=0] = fit$coef[(length(fit$coef)-pgamma+1):length(fit$coef)]}
	      if(rare==TRUE & pgamma>0){
	    	  coef = fit$coef[2]}}
	     
 
	    ##Calculate prior on the model
	    ##If inform ==TRUE use probit specification
	    if(inform==TRUE){
	      eta = a0+as.matrix(cov)%*%as.matrix(a1)
          lprob.inc = pnorm(0,mean=eta,lower.tail=FALSE,log.p=TRUE)
	      lprob.ninc = pnorm(0,mean=eta,lower.tail=TRUE,log.p=TRUE)
	      logPrM = t(Z)%*%lprob.inc + t(1-Z)%*%lprob.ninc}
	   
	    ##If inform==FALSE use BB(1,p) specification  
	    if(inform==FALSE){
	      logPrM = log(p) - lgamma(p+ p + 1) + lgamma(1 + pgamma) + lgamma(p + p - pgamma)}
	                  
           
	    
       	fitness = ll - logPrM
       	results = c(coef,fitness,exp(logPrM))
       	names(results) = c(paste("coef.",c(1:length(coef)),sep=""),"fitness","PrM")
       	return(results)
    	}
