
#######################################################################
## Bootstrap model stabilizer for linear models

BB.mod.stab.glm <- function(data, BB.data, s.model, model="linear")
  {
    if (model == "binomial") {
      regmod <- glm(s.model, data=BB.data, family = binomial(link="logit"),
                    na.action=na.exclude)
      c.regmod <- glm(s.model, data=data, family = binomial(link="logit"),
                      na.action=na.exclude)
    } else if (model == "linear") {
      regmod <- lm(s.model, data=BB.data, na.action=na.exclude)
      c.regmod <- lm(s.model, data=data, na.action=na.exclude)
    }
    c.namen <- names(c.regmod$coefficients)
    BB.namen <- names(regmod$coefficients)
    mislevpos <- !is.element(c.namen, BB.namen)
    if (any(mislevpos == T)) {
      help.coeff <- regmod$coefficients
      regmod$coefficients <- c.regmod$coefficients
      regmod$coefficients[mislevpos==T] <- 0
      regmod$coefficients[mislevpos==F] <- help.coeff
      regmod$xlevels <- c.regmod$xlevels
      regmod$rank <- c.regmod$rank
      regmod$assign <- c.regmod$assign
      regmod$qr$pivot <- c.regmod$qr$pivot
      regmod$qr$rank <- c.regmod$qr$rank
    }
    x <- list(model=regmod, c.model=c.regmod, mislevpos=mislevpos)
    return(x)
  }
