% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{simEnv}
\alias{simEnv}
\alias{simEnv,Arena-method}
\title{Main function for simulating all processes in the environment}
\usage{
simEnv(object, time, lrw = NULL, continue = FALSE, reduce = FALSE,
  diffusion = TRUE, diff_par = FALSE, cl_size = 2, sec_obj = "none",
  cutoff = 1e-06, pcut = 1e-06, with_shadow = FALSE, verbose = TRUE)

\S4method{simEnv}{Arena}(object, time, lrw = NULL, continue = FALSE,
  reduce = FALSE, diffusion = TRUE, diff_par = FALSE, cl_size = 2,
  sec_obj = "none", cutoff = 1e-06, pcut = 1e-06, with_shadow = FALSE,
  verbose = TRUE)
}
\arguments{
\item{object}{An object of class Arena or Eval.}

\item{time}{A number giving the number of iterations to perform for the simulation}

\item{lrw}{A numeric value needed by solver to estimate array size (by default lwr is estimated in the simEnv() by the function estimate_lrw())}

\item{continue}{A boolean indicating whether the simulation should be continued or restarted.}

\item{reduce}{A boolean indicating if the resulting \code{Eval} object should be reduced}

\item{diffusion}{True if diffusion should be done (default on).}

\item{diff_par}{True if diffusion should be run in parallel (default off).}

\item{cl_size}{If diff_par is true then cl_size defines the number of cores to be used in parallelized diffusion.}

\item{sec_obj}{character giving the secondary objective for a bi-level LP if wanted. Use "mtf" for minimizing total flux, "opt_rxn" for optimizing a random reaction, "opt_ex" for optimizing a random exchange reaction, and "sumex" for optimizing the sum of all exchange fluxes.}

\item{cutoff}{value used to define numeric accuracy}

\item{pcut}{A number giving the cutoff value by which value of objective function is considered greater than 0.}

\item{with_shadow}{True if shadow cost should be stores (default off).}

\item{verbose}{Set to false if no status messages should be printed.}
}
\value{
Returns an object of class \code{Eval} which can be used for subsequent analysis steps.
}
\description{
The generic function \code{simEnv} for a simple simulation of the environment.
}
\details{
The returned object itself can be used for a subsequent simulation, due to the inheritance between \code{Eval} and \code{Arena}. The parameter for sec_obj can be used to optimize a bi-level LP with a secondary objective if wanted. This can be helpful to subselect the solution space and create less alternative optimal solution. The secondary objective can be set to "mtf" to minimize the total flux, to simulate minimal enzyme usage of an organisms. If set to "opt_rxn" or "opt_ex", the secondary objective is picked as a random reaction or exchange reaction respectively everytime a fba is performed. This means that every individual of a population will select a different secondary reaction to optimize. The "sumex" option maximizes the secretion of products.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
}
\seealso{
\code{\link{Arena-class}} and \code{\link{Eval-class}}
}
