% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{cellgrowth}
\alias{cellgrowth}
\alias{cellgrowth,Human-method}
\title{Function implementing a growth model of a human cell}
\usage{
cellgrowth(object, population, j, occupyM, fbasol, tstep)

\S4method{cellgrowth}{Human}(object, population, j, occupyM, fbasol, tstep)
}
\arguments{
\item{object}{An object of class Human.}

\item{population}{An object of class Arena.}

\item{j}{The number of the iteration of interest.}

\item{occupyM}{A matrix indicating grid cells that are obstacles}

\item{fbasol}{Problem object according to the constraints and then solved with \code{optimizeProb}.}

\item{tstep}{A number giving the time intervals for each simulation step.}
}
\value{
Boolean variable of the \code{j}th individual indicating if individual died.
}
\description{
The generic function \code{cellgrowth} implements different growth models for an object of class Human.
}
\details{
Linear growth of organisms is implemented by adding the calculated growthrate by \code{optimizeLP} to the already present growth value. Exponential growth of organisms is implemented by adding the calculated growthrate multiplied with the current growth calculated by \code{optimizeLP} plus to the already present growth value.
}
\seealso{
\code{\link{Human-class}}, \code{\link{growLin}} and \code{\link{growExp}}
}
