% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{lysis}
\alias{lysis}
\alias{lysis,Organism-method}
\title{Lysis function of organismal cells by adding biomass_compounds to the medium}
\usage{
lysis(object, sublb, factor = object@minweight)

\S4method{lysis}{Organism}(object, sublb, factor = object@minweight)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{sublb}{A vector containing the substance concentrations in the current position of the individual of interest.}

\item{factor}{A number given the factor with which the biomass compound concentrations are multiplied to achieve the final concentration which is added to the environment}
}
\value{
Returns the updated vector containing the substance concentrations in the current position of the dead individual of interest.
}
\description{
The generic function \code{lysis} implements cell lysis by the stochiometric concentration of the biomass compounds of organisms to the concentration of substances in the environment
}
\details{
Lysis is implemented by taking the intersect between biomass compounds and the substances in the environment and adding the normalized stochiometric concentrations of the biomass compounds to the medium.
}
\examples{
NULL
}
\seealso{
\code{\link{Organism-class}} and \code{\link{optimizeLP}}
}
