% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{growth}
\alias{growth}
\alias{growth,Bac-method}
\title{Function implementing a growth model of a bacterium}
\usage{
growth(object, population, j, occupyM, fbasol, tstep)

\S4method{growth}{Bac}(object, population, j, occupyM, fbasol, tstep)
}
\arguments{
\item{object}{An object of class Bac.}

\item{population}{An object of class Arena.}

\item{j}{The index of the organism of interest in orgdat.}

\item{occupyM}{A matrix indicating grid cells that are obstacles}

\item{fbasol}{Problem object according to the constraints and then solved with \code{optimizeProb}.}

\item{tstep}{A number giving the time intervals for each simulation step.}
}
\value{
Boolean variable of the \code{j}th individual indicating if individual died.
}
\description{
The generic function \code{growth} implements different growth models for an object of class Bac.
}
\details{
Linear growth of organisms is implemented by adding the calculated growthrate by \code{optimizeLP} to the already present growth value. Exponential growth of organisms is implemented by adding the calculated growthrate multiplied with the current growth calculated by \code{optimizeLP} plus to the already present growth value
}
\seealso{
\code{\link{Bac-class}}, \code{\link{growLin}} and \code{\link{growExp}}
}
