% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{plotCurves2}
\alias{plotCurves2}
\alias{plotCurves2,Eval-method}
\title{Function for plotting the overall change as curves with maximally distinct colors}
\usage{
plotCurves2(object, legendpos = "topleft", ignore = c("EX_h(e)",
  "EX_pi(e)", "EX_h2o(e)"), num = 10, phencol = FALSE,
  biomcol = FALSE, dict = NULL, subs = list(), growthCurve = TRUE,
  subCurve = TRUE)

\S4method{plotCurves2}{Eval}(object, legendpos = "topright",
  ignore = c("EX_h(e)", "EX_pi(e)", "EX_h2o(e)"), num = 10,
  phencol = FALSE, biomcol = FALSE, dict = NULL, subs = list(),
  growthCurve = TRUE, subCurve = TRUE)
}
\arguments{
\item{object}{An object of class Eval.}

\item{legendpos}{A character variable declaring the position of the legend}

\item{ignore}{A list of character variables with substance names that sould be omitted in the plot}

\item{num}{An integer defining the number of substrates to be plot}

\item{phencol}{Boolean variable indicating whether phenotypes should be higlighted}

\item{biomcol}{A boolean indicating if biomass should be included in gowth curve}

\item{dict}{List defining new substance names. List entries are intepreted as old names and the list names as the new ones.}

\item{subs}{List of substance names. If empty, substances with highest variance will be used.}

\item{growthCurve}{True if growth curve should be shown (default TRUE)}

\item{subCurve}{True if substance curve should be shown (default TRUE)}
}
\value{
Returns two graphs in one plot: the growth curves and the curves of concentration changes
}
\description{
The generic function \code{plotCurves2} plots the growth curves and concentration changes of the most changing substances from simulation steps in an \code{Eval} object using maximally distinct colors.
}
\details{
The parameter \code{retdata} can be used to access the data used for the returned plots to create own custom plots.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
plotCurves2(eval)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{Arena-class}}
}
