% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Barycenter.R
\name{WaBarycenter}
\alias{WaBarycenter}
\title{Computation of a regularized Wasserstein Barycenter}
\usage{
WaBarycenter(images, maxIter = 10, lambda = FALSE, costMatrix = FALSE)
}
\arguments{
\item{images}{A list of matrices satisfying the prerequisites described above.}

\item{maxIter}{Maximum gradient iterations.}

\item{lambda}{Non-negative smoothing parameter. If FALSE then the algorithm uses a specific lambda proposed by M. Cuturi.}

\item{costMatrix}{A matrix of pairwise distances between the pixels. If FALSE then the algorithm uses the usual euclidean distance matrix where the images are embedded into a [0,1]x[0,1] pixel grid.}
}
\value{
The Barycenter of the images, represented by a \eqn{n x m} matrix. The function returns the Barycenter represented by a \eqn{n x m} matrix. In case the images are represented by square matrices it also prints the corresponding Barycenter.

Given the MNIST dataset, a Barycenter of the digit three is shown below. The Barycenter is based on 4351 images each represented by
a 28 x 28 pixel grid, respectively. The values for \code{lambda} and \code{maxIter} were set by default. The dataset is also available in this package (c.f. \link{MNIST_three}).

\figure{threeMNIST.png}{test}
}
\description{
Based on \link[RcppArmadillo]{RcppArmadillo} the function \code{WaBarycenter} takes in a list of matrices and computes the
corresponding Barycenter.
The list has to consist of matrices having all the same dimensions and each matrix represents the weights of the corresponding pixels of an image. The pixels should be scaled s.t. they sum up to one.
}
\examples{
#Computation of a Barycenter based on five images representing the digit eight, respectively.
WaBarycenter(eight,lambda=10)
#For a more reasonable but longer computation!
\dontrun{WaBarycenter(eight)}
}
\author{
Marcel Klatt
}
\references{
Cuturi, M.: \code{Fast Computation of Wasserstein Barycenters}, Proceedings of the International Conference on Machine Learning, Beijing, China, 2014
}

