% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetCollection.R
\name{tidy}
\alias{tidy}
\alias{tidy.GeneSetCollection}
\alias{tidy.GeneSet}
\title{Convert GSEABase classes to a TidySet}
\usage{
tidy(object)

\method{tidy}{GeneSetCollection}(object)

\method{tidy}{GeneSet}(object)
}
\arguments{
\item{object}{A GeneSetCollection or a GeneSet derived object}
}
\value{
A TidySet object.
}
\description{
Convert GSEABase classes to a TidySet
}
\section{Methods (by class)}{
\itemize{
\item \code{tidy(GeneSetCollection)}: Converts to a tidySet given a GeneSetCollection

\item \code{tidy(GeneSet)}: Converts to a tidySet given a GeneSet

}}
\examples{
# Needs GSEABase pacakge from Bioconductor
if (requireNamespace("GSEABase", quietly = TRUE)) {
    library("GSEABase")
    gs <- GeneSet()
    gs
    tidy(gs)
    fl <- system.file("extdata", "Broad.xml", package="GSEABase")
    gs2 <- getBroadSets(fl) # actually, a list of two gene sets
    TS <- tidy(gs2)
    dim(TS)
    sets(TS)
}
}
