% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.raw.data.R
\name{plot.by.segreg.type}
\alias{plot.by.segreg.type}
\title{Draw a graphic showing the number of markers of each segregation pattern.}
\usage{
\method{plot}{by.segreg.type}(x, subcateg = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{onemap}}

\item{subcateg}{a TRUE/FALSE option to indicate if results will be plotted showing
all possible categories (only for outcrossing populations)}

\item{...}{Not used}
}
\value{
a ggplot graphic
}
\description{
The function receives an object of class \code{onemap}.
For outcrossing populations, it can show detailed information (all 18 possible categories),
or a simplified version.
}
\examples{
data(example.out) #Outcrossing data
plot.by.segreg.type(example.out)
plot.by.segreg.type(example.out, subcateg=FALSE)

# You can store the graphic in an object, then save it.
# For details, see the help of ggplot2's function ggsave()
data(example.out) #Outcrossing data
g <- plot.by.segreg.type(example.out)
ggsave("SegregationTypes.jpg", g, width=7, height=4, dpi=600)

}
