\name{CPPpostSample}
\alias{CPPpostSample}
\title{Function to Sample Hazard Rates from CPP Posteriors}
\description{A function to generate a random sample of hazard rates from the posterior distribution
originated by a CPP prior through the observation of a sequence of possibly right censored times to event.}
\usage{CPPpostSample(hyp, times, obs = NULL, mclen = 10, burnin = 0, thin = 1, lab = FALSE)}
\arguments{
  \item{hyp}{list of hyperparameters (as generated by \code{\link{CPPpriorElicit}})}
  \item{times}{vector of (possibly right censored) times to event}
  \item{obs}{vector of censoring indicators (0 = censored, 1 = exact)}
  \item{mclen}{requested sample size}
  \item{burnin}{burn-in parameter}
  \item{thin}{thinning parameter}
  \item{lab}{logical: should latent labels be returned?}
}
\details{A random scan (random start) Gibbs sampler (with slice sampling updating of jump-times)
is used to generate a Markov chain sample of length \code{mclen} from the posterior distribution
originated by \code{hyp} through the observation of \code{times} and \code{obs}; see La Rocca (2005).

The first \code{burnin} states of the Markov chain are discarded, then one every \code{thin} is kept.

If \code{obs} is \code{NULL}, it is assumed that all observations are exact (no censoring).
}
\value{A list with eight components:
  \item{hyp}{list of hyperparameters identifying the CPP prior that originated the posterior distribution
                    from which the sample was extracted (copy of the input argument)}
  \item{dat}{dataframe with two variables (\code{times} and \code{obs}) containing the observations
                   on which the posterior distribution is based}
  \item{burnin}{burn-in parameter used (copy of the input argument)}
  \item{thin}{thinning parameter used (copy of the input argument)}
  \item{sgm}{matrix with \code{mclen} rows (and \code{hyp$F} columns) containing the CPP jump-times}
  \item{xi0}{matrix with \code{mclen} rows (and just one column) containing the jump-sizes in the origin}
  \item{csi}{matrix with \code{mclen} rows (and \code{hyp$F} columns) containing the CPP jump-sizes}
  \item{gam}{matrix with \code{mclen} rows (and \code{length(times)} columns) containing the latent labels
                    (\code{NULL} if \code{lab} is \code{FALSE})}
}
\note{The latent label \eqn{\gamma_i} is equal to \eqn{j} when the \eqn{i}-th time to event
         is associated with the \eqn{j}-th CPP jump; it is only defined for exact observations,
         but for censored observations it is conventionally set equal to \eqn{-1}.}
\references{
Luca La Rocca (2005). On Bayesian Nonparametric Estimation of Smooth Hazard Rates with a View to Seismic Hazard Assessment.
\emph{Research Report n. 38-05}, Department of Social, Cognitive and Quantitative Sciences, Reggio Emilia, Italy.
}
\seealso{\code{\link{BayHaz-package}}, \code{\link{CPPevalHR}}, \code{\link{CPPplotHR}}, \code{\link{CPPpost2mcmc}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a CPP prior distribution
hypars<-CPPpriorElicit(r0 = 0.1, H = 1, T00 = 50, M00 = 2)
# load a data set
data(earthquakes)

# generate a posterior sample
post<-CPPpostSample(hypars, times = earthquakes$ti, obs = earthquakes$ob)
}
\keyword{distribution}
\keyword{survival}
\keyword{smooth}
