% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GibbsMH.R
\name{GibbsMH.NoBorrow}
\alias{GibbsMH.NoBorrow}
\title{GibbsMH sampler, without Bayesian Borrowing}
\usage{
\method{GibbsMH}{NoBorrow}(
  Y,
  I,
  X = NULL,
  Y_0 = NULL,
  I_0 = NULL,
  X_0 = NULL,
  initial_parameters,
  hyperparameters = list(a_sigma = 1, b_sigma = 1, Jmax = 5, clam_smooth = 0.8,
    cprop_beta = 0.3, phi = 3, pi_b = 0.5),
  lambda_hyperparameters = list(a_lambda = 0.01, b_lambda = 0.01),
  iter = 1500L,
  warmup_iter = 10L,
  refresh = 0,
  max_grid = 2000L
)
}
\arguments{
\item{Y}{data}

\item{I}{event indicator}

\item{X}{design matrix}

\item{Y_0}{historical data, default is NULL}

\item{I_0}{historical event indicator, default is NULL}

\item{X_0}{historical design matrix, default is NULL}

\item{initial_parameters}{list containing initial values of each parameter}

\item{hyperparameters}{list containing hyperparameters}

\item{lambda_hyperparameters}{contains two hyperparameters (a and b) used for
the update of lambda}

\item{iter}{number of iterations for MCMC sampler, excluding warmup, 
default is 2000}

\item{warmup_iter}{number of warmup iterations (burn-in) for MCMC sampler, 
default is 2000}

\item{refresh}{number of iterations between printed screen updates, 
default is 500}

\item{max_grid}{grid size for the smoothed baseline hazard, default is 2000}
}
\value{
list with values after each iteration for parameters: out_fixed (J, 
 mu, sigma2, beta), lambda, s, as well as tuning values of the total number 
 of accepts: lambda_move and beta_move. Also included is the out_slam which 
 contains the shrunk estimate of the baseline hazard.
}
\description{
An MCMC sampler for time-to-event data, without Bayesian Borrowing.
We obtain a flexible baseline hazard function by making the split points 
random within a piecewise exponential model and using a Gaussian Markov 
random field prior to smooth the baseline hazards. Only calls the sampler and
does not run any input checks. Best practice is to call BayesFBHborrow(), if the 
user is not familiar with the model at hand.
}
\examples{
set.seed(123)
# Load example data "weibull_cc" and set your initial values and hyperparameters
data(weibull_cc, package = "BayesFBHborrow")

# The datasets consists of 3 columns named "tte", "event" and "X". To 
# explicitly run the sampler, extract the samples as following
Y <- weibull_cc$tte
I <- weibull_cc$event
X <- weibull_cc$X_trt

# Set your initial values and hyper parameters
s <- c(0, quantile(weibull_cc$tte, c(0.25, 0.75, 1.0), names = FALSE))
group_data <- group_summary(weibull_cc[weibull_cc$X_trt == 0,]$tte, 
                            weibull_cc[weibull_cc$X_trt == 0,]$event, NULL, s)
lambda_init <- init_lambda_hyperparameters(group_data, s) 
initial_param <- list("J" = 2, 
                      "s_r" = s[2:3], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "lambda" = mapply(stats::rgamma, n=1, 
                                        shape = lambda_init$shape, 
                                        rate = lambda_init$rate), 
                       "beta" = 0)

hyper <-  list("a_sigma" = 2,
               "b_sigma" = 2,
               "Jmax" = 5, 
               "clam_smooth" = 0.5, 
               "cprop_beta" = 0.3,
               "phi" = 2, 
               "pi_b" = 0.5)

output <- GibbsMH(Y, I, X, NULL, NULL, NULL,
                          initial_param,
                          hyper,
                          iter = 5, warmup_iter = 1)
}
