% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Est_quant.R
\name{LN_QuantReg}
\alias{LN_QuantReg}
\title{Bayesian estimate of the log-normal conditioned quantiles}
\usage{
LN_QuantReg(
  y,
  X,
  Xtilde,
  quant,
  method = "weak_inf",
  guess_s2 = NULL,
  y_transf = TRUE,
  CI = TRUE,
  method_CI = "exact",
  alpha_CI = 0.05,
  type_CI = "two-sided",
  rel_tol_CI = 1e-05,
  nrep_CI = 1e+05
)
}
\arguments{
\item{y}{Vector of observations of the response variable.}

\item{X}{Design matrix.}

\item{Xtilde}{Covariate patterns of the units to estimate.}

\item{quant}{Number between 0 and 1 that indicates the quantile of interest.}

\item{method}{String that indicates the prior setting to adopt. Choosing \code{"weak_inf"}
a weakly informative prior setting is adopted, whereas selecting
\code{"optimal"} the hyperparameters are fixed trough a numerical optimization algorithm
aimed at minimizing the frequentist MSE.}

\item{guess_s2}{Specification of a guess for the variance if available. If not, the sample estimate is used.}

\item{y_transf}{Logical. If \code{TRUE}, the \code{y} vector is assumed already log-transformed.}

\item{CI}{Logical. With the default choice \code{TRUE}, the posterior credibility interval is computed.}

\item{method_CI}{String that indicates if the limits should be computed through the logSMNG
quantile function \code{\link{qlSMNG}} (option \code{"exact"}, default), or by randomly generating
(\code{"simulation"}) using the function \code{\link{rlSMNG}}.}

\item{alpha_CI}{Level of credibility of the posterior interval.}

\item{type_CI}{String that indicates the type of interval to compute: \code{"two-sided"} (default),
\code{"UCL"} (i.e. Upper Credible Limit) for upper one-sided intervals  or \code{"LCL"} (i.e. Lower
Credible Limit) for lower one-sided intervals.}

\item{rel_tol_CI}{Level of relative tolerance required for the \code{integrate} procedure or for the infinite sum.
Default set to \code{1e-5}.}

\item{nrep_CI}{Number of simulations for the C.I. in case of \code{method="simulation"} and for the posterior of the coefficients vector.}
}
\value{
The function returns the prior parameters and their posterior values, summary statistics of the parameters \eqn{\beta} and \eqn{\sigma^2}, and the estimate of the specified quantile:
the posterior mean and variance are provided by default. Moreover the user can control the computation of posterior intervals.

#'@source

Gardini, A., C. Trivisano, and E. Fabrizi. \emph{Bayesian inference for quantiles of the log-normal distribution.} Biometrical Journal (2020).
}
\description{
This function produces a point estimate for the log-normal distribution quantile of fixed level \code{quant}.
}
\details{
The function allows to carry out Bayesian inference for the conditional quantiles of a sample that is assumed log-normally distributed.
The design matrix containing the covariate patterns of the sampled units is \code{X}, whereas \code{Xtilde}
contains the covariate patterns of the unit to predict.

The classical log-normal linear mixed model is assumed and the quantiles are estimated as:
\deqn{\theta_p(x)=exp(x^T\beta+\Phi^{-1}(p))}.

A generalized inverse Gaussian prior is assumed for the variance in the log scale \eqn{\sigma^2}, whereas a
flat improper prior is assumed for the vector of coefficients \eqn{\beta}.

Two alternative hyperparamters setting are implemented (choice controlled by the argument \code{method}): a weakly
informative proposal and an optimal one.
}
