% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{metropolis_hastings_rho}
\alias{metropolis_hastings_rho}
\title{Metropolis-Hastings Rho}
\usage{
metropolis_hastings_rho(
  alpha,
  n_items,
  rankings,
  rho,
  metric = "footnote",
  leap_size = 1L
)
}
\arguments{
\item{alpha}{Numeric value of the scale parameter}

\item{n_items}{Integer is the number of items in a ranking
A matrix of size \eqn{N }\eqn{\times}{x}\eqn{ n_items} of
rankings in each row. Alternatively, if \eqn{N} equals 1, \code{rankings}
can be a vector.}

\item{rankings}{A matrix of size \eqn{N }\eqn{\times}{x}\eqn{ n_items} of
rankings in each row. Alternatively, if \eqn{N} equals 1, \code{rankings}
can be a vector.}

\item{rho}{A ranking sequence}

\item{metric}{Character string specifying the distance measure to use.
Available options are \code{"kendall"}, \code{"cayley"}, \code{"hamming"},
\code{"ulam"}, \code{"footrule"} and \code{"spearman"}.}

\item{leap_size}{Integer specifying the step size of the leap-and-shift
proposal distribution.}
}
\description{
Function to perform Metropolis-Hastings for new rho under the Mallows model with footrule distance metric!
}
\examples{
rho <- t(c(1,2,3,4,5,6))
alpha <- 2
metric <- "footrule"
n_items <- 6

metropolis_hastings_rho(
	alpha = alpha, n_items = n_items, rankings = rho, metric = metric,
	rho = rho, leap_size = 1
)

metropolis_hastings_rho(
	alpha = alpha, n_items = n_items, rankings = rho, metric = metric,
	rho = rho, leap_size = 2
)

metropolis_hastings_rho(
	alpha = alpha, n_items = n_items, rankings = rho, metric = metric,
	rho = rho, leap_size = 3
)

rankings <- sample_mallows(
 rho0 = rho, alpha0 = alpha, n_samples = 10, burnin = 1000, thinning = 500
)
metropolis_hastings_rho(
	alpha = alpha, n_items = n_items, rankings = rankings, metric = metric,
	rho = rho, leap_size = 1
)

}
\author{
Anja Stein
}
