% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_consensus.R
\name{compute_consensus.SMCMallows}
\alias{compute_consensus.SMCMallows}
\title{Compute Consensus Ranking}
\usage{
\method{compute_consensus}{SMCMallows}(model_fit, type = "CP", ...)
}
\arguments{
\item{model_fit}{An object of class \code{SMCMallows}, returned from
\code{\link{smc_mallows_new_item_rank}} or
\code{\link{smc_mallows_new_users}}.}

\item{type}{Character string specifying which consensus to compute. Either
\code{"CP"} or \code{"MAP"}. Defaults to \code{"CP"}.}

\item{...}{Other optional arguments passed to methods. Currently not used.}
}
\description{
Compute the consensus ranking using either cumulative probability (CP) or
maximum a posteriori (MAP) consensus \insertCite{vitelli2018}{BayesMallows}.
For mixture models, the consensus is given for each mixture.
}
\examples{
# Basic elements
data <- sushi_rankings[1:100, ]
n_items <- ncol(data)
leap_size <- floor(n_items / 5)
metric <- "footrule"
Time <- 20
N <- 100

# Prepare exact partition function
cardinalities <- prepare_partition_function(metric = metric,
                                            n_items = n_items)$cardinalities

# Performing SMC
smc_test <- smc_mallows_new_users(
  R_obs = data, type = "complete", n_items = n_items,
  metric = metric, leap_size = leap_size,
  N = N, Time = Time,
  cardinalities = cardinalities,
  mcmc_kernel_app = 5,
  num_new_obs = 5,
  alpha_prop_sd = 0.5,
  lambda = 0.15,
  alpha_max = 1e6
)

compute_posterior_intervals(smc_test, parameter = "rho")

compute_consensus(model_fit = smc_test, type = "CP")
compute_consensus(model_fit = smc_test, type = "MAP")

compute_posterior_intervals(smc_test, parameter = "alpha")
}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus.BayesMallows}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals.BayesMallows}()},
\code{\link{compute_posterior_intervals.SMCMallows}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallowsMixtures}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
