% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_mixture.R
\name{bayes_mixture}
\alias{bayes_mixture}
\title{Creating a S3 object of class \code{bayes_mixture}}
\usage{
bayes_mixture(
  mcmc,
  data,
  burnin,
  dist = NA_character_,
  pdf_func = NULL,
  dist_type = NA_character_,
  loglik = NULL,
  vars_to_keep = NA_character_,
  vars_to_rename = NA_character_,
  loc = NA_character_
)
}
\arguments{
\item{mcmc}{A matrix of MCMC draws with one column per variable, e.g. eta1, eta2, ..., mu1, mu2, etc...}

\item{data}{Vector of observation used for estimating the model.}

\item{burnin}{Number of draws to discard as burnin.}

\item{dist}{Distribution family of the mixture components supported by
the package (i.e. \code{"normal"}, \code{"student"}, \code{"skew_normal"} or \code{"shifted_poisson"}).
If left unspecified, \code{pdf_func} is required.}

\item{pdf_func}{(function) Pdf or pmf of the mixture components;
this input is used only if \code{dist} is left unspecified.
pdf_func should have two arguments : (i) the observation where the pdf is evaluated;
(ii) a named vector representing the function parameters. For instance a normal pdf would take the form:
\code{pdf_func <- function(x, pars) dnorm(x, pars['mu'], pars['sigma'])}.
The names of \code{pars} should correspond to variables in \code{mcmc}, e.g. \code{"mu1"}, \code{"mu2"} etc...}

\item{dist_type}{Either \code{"continuous"} or \code{"discrete"}.}

\item{loglik}{Vector showing the log likelihood at each MCMC draw.}

\item{vars_to_keep}{(optional) Character vector containing the names
of the variables to keep in \code{mcmc}.}

\item{vars_to_rename}{(optional) Use for renaming variables/parameters in \code{mcmc}.
A named character vector where the names are the new variable names
and the elements the variables in \code{mcmc}, e.g. c("new_name" = "old_name").}

\item{loc}{(for continuous mixtures other than Normal mixtures) String indicating the location parameter
of the distribution; the latter is used to initialise the MEM algorithm.}
}
\value{
A list of class \code{bayes_mixture} containing:
\item{data}{Same as argument.}
\item{mcmc}{Matrix of MCMC draws where the rows corresponding to burnin have been discarded;}
\item{mcmc_all}{Matrix of MCMC draws.}
\item{loglik}{Log likelihood at each MCMC draw.}
\item{K}{Number of components.}
\item{dist}{Same as argument.}
\item{pdf_func}{The pdf/pmf of the mixture components.}
\item{dist_type}{Type of the distribution, i.e. continuous or discrete.}
\item{pars_names}{Names of the mixture components' parameters.}
\item{loc}{Name of the location parameter of the mixture components.}
\item{nb_var}{Number of parameters in the mixture distribution.}
}
\description{
Creates an object of class \code{bayes_mixture} which can subsequently be used as argument in \code{\link[=bayes_mode]{bayes_mode()}}.
This function is useful for users who want to use the mode inference capabilities of \code{BayesMultiMode} with mixture
estimated using external software.
}
\examples{

# Example with a Student t ================================================

# Constructing synthetic mcmc output
mu = c(0.5,6)
mu_mat = matrix(rep(mu, 100) + rnorm(200, 0, 0.1),
            ncol = 2, byrow = TRUE)

omega = c(1,2)
sigma_mat = matrix(rep(omega, 100) + rnorm(200, 0, 0.1),
            ncol = 2, byrow = TRUE)

nu = c(5,5)
nu_mat = matrix(rep(nu, 100) + rnorm(200, 0, 0.1),
            ncol = 2, byrow = TRUE)

eta = c(0.8,0.2)
eta_mat = matrix(rep(eta[1], 100) + rnorm(100, 0, 0.05),
            ncol = 1)
eta_mat = cbind(eta_mat,1-eta_mat)

xi_mat = matrix(0,100,2)

fit = cbind(eta_mat, mu_mat, sigma_mat, nu_mat, xi_mat)
colnames(fit) = c("eta1", "eta2", "mu1", "mu2",
                  "omega1", "omega2", "nu1", "nu2", "xi1", "xi2")
                  
# sampling observations
data = c(sn::rst(eta[1]*1000, mu[1], omega[1], nu = nu[1]),
        sn::rst(eta[2]*1000, mu[2], omega[2], nu = nu[2]))
        
pdf_func = function(x, pars) {
  sn::dst(x, pars["mu"], pars["sigma"], pars["xi"], pars["nu"])
}

dist_type = "continuous"

BM = bayes_mixture(fit, data, burnin = 50,
pdf_func = pdf_func, dist_type = dist_type,
vars_to_rename = c("sigma" = "omega"), loc = "xi")
# plot(BM)
}
