% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_mode.R
\name{bayes_mode}
\alias{bayes_mode}
\title{Bayesian mode inference}
\usage{
bayes_mode(
  BayesMix,
  rd = 1,
  tol_mixp = 0,
  tol_x = sd(BayesMix$data)/10,
  tol_conv = 1e-08,
  inside_range = TRUE,
  range = c(min(BayesMix$data), max(BayesMix$data))
)
}
\arguments{
\item{BayesMix}{An object of class \code{bayes_mixture} generated with either \code{\link[=bayes_fit]{bayes_fit()}} or \code{\link[=bayes_mixture]{bayes_mixture()}}.}

\item{rd}{(for continuous mixtures) Integer indicating the number of decimal places when rounding the distribution's support.
It is necessary to compute posterior probabilities of mode locations.}

\item{tol_mixp}{Components with a mixture proportion below \code{tol_mixp} are discarded when estimating modes;
note that this does not apply to the biggest component so that it is not possible to discard all components;
should be between \code{0} and \code{1}; default is \code{0}.}

\item{tol_x}{(for continuous mixtures) Tolerance parameter for distance in-between modes; default is \code{sd(data)/10}
where data is the vector of observations from \code{BayesMix}.
If two modes are closer than \code{tol_x}, only the first estimated mode is kept.}

\item{tol_conv}{(for continuous mixtures) Tolerance parameter for convergence of the algorithm; default is \code{1e-8}.}

\item{inside_range}{Should modes outside of \code{range} be discarded? Default is \code{TRUE}.}

\item{range}{limits of the support where modes are saved (if \code{inside_range} is \code{TRUE});
default is \code{c(min(BayesMix$data), max(BayesMix$data))}.
This sometimes occurs with very small components when K is large.}
}
\value{
A list of class \code{bayes_mode} containing:
\item{data}{From \code{BayesMix}.}
\item{dist}{From \code{BayesMix}.}
\item{dist_type}{From \code{BayesMix}.}
\item{pars_names}{From \code{BayesMix}.}
\item{modes}{Matrix with a row for each draw and columns showing modes.}
\item{p1}{Posterior probability of unimodality.}
\item{p_nb_modes}{Matrix showing posterior probabilities for the number of modes.}
\item{p_mode_loc}{Matrix showing posterior probabilities for mode locations.}
\item{mix_density}{Mixture density at all locations in each draw.}
\item{algo}{Algorithm used for mode estimation.}
\item{range}{Range outside which modes are discarded if \code{inside_range} is \code{TRUE}.}
\item{BayesMix}{\code{BayesMix}.}
}
\description{
Bayesian inference on the modes in a univariate mixture estimated with MCMC methods, see \insertCite{Cross2024;textual}{BayesMultiMode}.
Provides posterior probabilities of the number of modes and their locations.
Under the hood it calls the function \code{\link[=mix_mode]{mix_mode()}} to find the modes in each MCMC draw.
}
\details{
Each draw from the MCMC output after burnin, \eqn{\theta^{(d)}, \quad d = 1,...,D}, leads to a posterior predictive probability
density/mass function:
\deqn{p(y | \theta^{(d)}) =\sum_{k=1}^{K} \pi_k^{(d)} p(y | \theta_k^{(d)}).}
Using this function, the mode in draw \eqn{d} \eqn{y_{m}^{(d)}}, \eqn{m = 1,..., M^{(d)}},
where \eqn{M^{(d)}} is the number of modes, are estimated using the algorithm mentioned
in the description above.

After running this procedure across all retained posterior draws,
we compute the posterior probability for the number of modes being \eqn{M} as:
\deqn{P(\#\text{modes}=M)=\frac{1}{D}\sum_{d=1}^{D}1(M^{(d)} = M).}
Similarly, posterior probabilities for locations of the modes are given by:
\deqn{P(y=\text{mode})=\frac{1}{D}\sum_{d=1}^{D} \sum_{m=1}^{M^{(d)}} 1(y = y_m^{(d)}),}
for each location \eqn{y} in the range \eqn{[\min(y),\max(y)]}. Obviously,
continuous data are not defined on a discrete support;
it is therefore necessary to choose a rounding decimal to discretize their support (with the \code{rd} argument).
}
\examples{
# Example with galaxy data ================================================
set.seed(123) 

# retrieve galaxy data
y = galaxy

# estimation
bayesmix = bayes_fit(data = y,
                           K = 5, #not many to run the example rapidly
                           dist = "normal",
                           nb_iter = 500, #not many to run the example rapidly
                           burnin = 100)

# mode estimation
BayesMode = bayes_mode(bayesmix)

# plot 
# plot(BayesMode, max_size = 200)

# summary 
# summary(BayesMode)

# Example with DNA data ================================================
set.seed(123) 

# retrieve DNA data
y = d4z4

# estimation
bayesmix = bayes_fit(data = y,
                           K = 5, #not many to run the example rapidly
                           dist = "shifted_poisson",
                           nb_iter = 500, #not many to run the example rapidly
                           burnin = 100)

# mode estimation
BayesMode = bayes_mode(bayesmix)

# plot 
# plot(BayesMode, max_size = 200)

# summary 
# summary(BayesMode)

# Example with a Student t ================================================
mu = c(0.5,6)
sigma = c(1,2)
nu = c(5,5)
p = c(0.8,0.2)#'
data = c(sn::rst(p[1]*1000, mu[1], sigma[1], nu = nu[1]),
         sn::rst(p[2]*1000, mu[2], sigma[2], nu = nu[2]))

fit = c(eta = p, mu = mu, sigma = sigma, nu = nu, xi = c(0,0))
fit = rbind(fit, fit)

pdf_func = function(x, pars) {
  sn::dst(x, pars["mu"], pars["sigma"], pars["xi"], pars["nu"])
}

dist_type = "continuous"

bayesmix = bayes_mixture(fit, data, burnin = 1, 
pdf_func = pdf_func, dist_type = dist_type, loc = "mu")

BayesMode = bayes_mode(bayesmix)

# plot 
# plot(BayesMode, max_size = 200)

# summary 
# summary(BayesMode)

}
\references{
\insertAllCited{}
}
