% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E1_Marginals.R
\name{Marginals}
\alias{Marginals}
\title{Obtain marginal distributions}
\usage{
Marginals(tree, vars)
}
\arguments{
\item{tree}{a \code{\linkS4class{ClusterTree}} object}

\item{vars}{a \code{vector} of variables for query of marginal distributions}
}
\value{
\describe{
 \item{\code{marginals}}{a \code{list} of marginal distributions}
 \item{\code{types}}{a named \code{vector} indicating the types of the variables whose
 marginals are queried: \code{TRUE} for discrete, \code{FALSE} for continuous.}
}
}
\description{
Get the marginal distributions of multiple variables
}
\details{
Get the marginal distributions of multiple variables. The function \code{Marginals}
returns a \code{list} of marginal distributions. The marginal distribution of a discrete variable 
is a named vector of probabilities. Meanwhile, the marginal distributions of 
continous variables in a CG-BN model are mixtures of Gaussian distributions. 
To fully represent this information, the marginal of a continuous variable is represented by 
a \code{data.frame} with three columns to specify 
parameters for each Gaussian distribution in the mixture, which are

\describe{
 \item{\code{mean}}{the mean value of a Gaussian distribution.}
 \item{\code{sd}}{the standard deviation of a Gaussian distribution.}
 \item{\code{n}}{the number of Gaussian mixtures}
}
}
\examples{

data(liver)
cst <- ClusterTreeCompile(dag=liver$dag, node.class=liver$node.class)
models <- LocalModelCompile(data=liver$data, dag=liver$dag, node.class=liver$node.class)
tree.init <- ElimTreeInitialize(tree=cst$tree.graph, 
                                dag=cst$dag, 
                                model=models, 
                                node.sets=cst$cluster.sets, 
                                node.class=cst$node.class)
tree.init.p <- PropagateDBN(tree.init)
tree.post <- AbsorbEvidence(tree.init.p, c("Nr1i3", "chr1_42.65"), list(1,"1"))
marg <- Marginals(tree.post, c("HDL", "Ppap2a"))
marg$marginals$HDL
head(marg$marginals$Ppap2a)

}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks. 
Journal of Machine Learning Research, 6(Sep), 1517-1550.
}
\seealso{
\code{\link{PlotMarginals}} for visualization of the marginal distributions,
\code{\link{SummaryMarginals}} for summarization of the marginal distributions of 
continuous variables.
}
\author{
Han Yu
}
