% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_func.R
\name{two.grp.fixed.a0}
\alias{two.grp.fixed.a0}
\title{Model fitting for two groups (treatment and control group, no covariates) with fixed a0 when outcome follows Normal distribution}
\usage{
two.grp.fixed.a0(
  y.c,
  n.c,
  v.c,
  historical = matrix(0, 1, 4),
  nMC = 10000,
  nBI = 250
)
}
\arguments{
\item{y.c}{Sum of responses (assumed to follow Normal distribution) for the control group.}

\item{n.c}{Sample size of the control group.}

\item{v.c}{Sample variance of responses for the control group.}

\item{historical}{(Optional) matrix of historical dataset(s) with four columns:
\itemize{
\item The first column contains the sum of responses for the control group.
\item The second column contains the sample size of the control group.
\item The third column contains the sample variance of responses for the control group.
\item The fourth column contains the discounting parameter value \eqn{a_0} (between 0 and 1).
}
Each row represents a historical dataset.}

\item{nMC}{Number of iterations (excluding burn-in samples) for the Gibbs sampler. The default is 10,000.}

\item{nBI}{Number of burn-in samples for the Gibbs sampler. The default is 250.}
}
\value{
Posterior samples of \eqn{\mu_c}, \eqn{\tau} and \eqn{\tau_k}'s (if historical data is given) are returned.
}
\description{
Model fitting using power priors for two groups (treatment and control group, no covariates) with fixed \eqn{a_0} when outcome follows Normal distribution
}
\details{
The power prior is applied on the data of the control group only.
Therefore, only summaries of the responses of the control group need to be entered.

The responses are assumed to follow \eqn{N(\mu_c, \tau^{-1})} where \eqn{\mu_c} is the mean of responses for the control group
and \eqn{\tau} is the precision parameter. Each historical dataset \eqn{D_{0k}} is assumed to have a different precision parameter \eqn{\tau_k}.
The initial prior for \eqn{\tau} is the Jeffery's prior, \eqn{\tau^{-1}}, and the initial prior for \eqn{\tau_k} is \eqn{\tau_k^{-1}}. The initial prior for the \eqn{\mu_c} is the uniform improper prior.
Posterior samples are obtained through Gibbs sampling.
}
\examples{
y.c <- 200 # The responses are assumed to follow normal distribution
n.c <- 100
v.c <- 2

# Simulate three historical datasets
historical <- matrix(0, ncol=4, nrow=3)
historical[1,] <- c(200, 100, 2, 0.3)
historical[2,] <- c(300, 100, 2, 0.5)
historical[3,] <- c(400, 100, 2, 0.7)

set.seed(1)
result <- two.grp.fixed.a0(y.c, n.c, v.c, historical, nMC=10000, nBI=250)
}
\references{
Chen, Ming-Hui, et al. "Bayesian design of noninferiority trials for medical devices using historical data." Biometrics 67.3 (2011): 1163-1170.
}
\seealso{
\code{\link{power.two.grp.fixed.a0}}
}
