% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCDepGammaFirst.R
\name{MCMCDepGammaFirst}
\alias{MCMCDepGammaFirst}
\title{Sampler for the first interval for the piecewise exponential prior
with dependent Gamma heights.}
\usage{
MCMCDepGammaFirst(
  current,
  next.haz,
  failure,
  exposure,
  alpha.dep = 1,
  alpha0.dep = 1.5,
  beta0.dep = 1
)
}
\arguments{
\item{current}{The value of the height of the first interval from the
previous iteration.}

\item{next.haz}{The value of the height of the second interval from the
previous iteration.}

\item{failure}{The number of individuals who had an event during the first
interval.}

\item{exposure}{The total amount of time all individuals were exposed for
during the first interval.}

\item{alpha.dep}{The main parameter \eqn{\alpha} for the dependent Gamma
prior, as described in the documentation for \link{BayesSurv}. It is
recommended to take \code{alpha.dep} smaller than \code{alpha0.dep}.}

\item{alpha0.dep}{The shape parameter for the Gamma prior on the histogram
height for the first interval. It is recommended to take \code{alpha.dep}
smaller than \code{alpha0.dep}.}

\item{beta0.dep}{The rate parameter for the Gamma prior on the histogram
height for the first interval.}
}
\value{
\item{res}{A new sample of the histogram height of the first interval.}
}
\description{
This is the sampler for the first interval in case the piecewise exponential
prior with dependent Gamma heights is selected. The sampler is described in
the Supplement to Castillo and Van der Pas (2020). Most users of the package
will not work with this function directly, but instead use the main function
\link{BayesSurv}, in which this particular function is incorporated.
}
\references{
Castillo and Van der Pas (2020). Multiscale Bayesian survival
  analysis. <arXiv:2005.02889>.
}
\seealso{
\link{BayesSurv}, which computes the posterior mean and credible
  bands for the cumulative hazard and survival functions, as well as the
  posterior mean for the hazard. Within \link{BayesSurv}, the present
  function as well as \link{MCMCDepGammaIntermediate} is called through
  \link{SamplePosteriorDepGamma}.
}
