% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMAcoeff.R
\name{BMAcoeff}
\alias{BMAcoeff}
\title{Bayesian Model Averaged estimations of regression coefficients}
\usage{
BMAcoeff(x, n.sim = 10000, method = "svd")
}
\arguments{
\item{x}{An object of class \code{Bvs}}

\item{n.sim}{Number of simulations to be produced}

\item{method}{Text specifying the matrix decomposition used to determine the
matrix root of 'sigma' when simulating from the multivariate t distribution.
Possible methods are eigenvalue decomposition ('"eigen"', default), singular
value decomposition ('"svd"'), and Cholesky decomposition ('"chol"'). See
the help of command \code{rmvnorm} in package \code{mvtnorm} for more
details}
}
\value{
\code{BMAcoeff} returns an object of class \code{bma.coeffs} which
is a matrix with \code{n.sim} rows with the simulations. Each column of the
matrix corresponds to a regression coefficient in the full model.
}
\description{
Samples of the model averaged objective posterior distribution of regression
coefficients
}
\details{
The distribution that is sampled from is the discrete mixture of the
(objective) posterior distributions of the regression coefficients with
weights proportional to the posterior probabilities of each model. That is,
from

\eqn{latex}{ sum_M f(\beta | data, M) Pr(M | data)}

The models used in the mixture above are the retained best models (see the
argument \code{n.keep} in \link[BayesVarSel]{Bvs}) if \code{x} was generated
with \code{Bvs} and the sampled models with the associated frequencies if
\code{x} was generated with \code{GibbsBvs}. The formula for the objective
posterior distribution within each model \eqn{latex}{f(\beta | data, M)} is
taken from Bernardo and Smith (1994) page 442.

Note: The above mixture is potentially highly multimodal and this command
ends with a multiple plot with the densities of the different regression
coefficients to show the user this peculiarity. Hence which summaries should
be used to describe this distribution is a delicate issue and standard
functions like the mean and variance are not recommendable.
}
\examples{

\dontrun{

#Analysis of Crime Data
#load data
data(UScrime)

crime.Bvs<- Bvs(formula= y ~ ., data=UScrime, n.keep=1000)
crime.Bvs.BMA<- BMAcoeff(crime.Bvs, n.sim=10000)
#the best 1000 models are used in the mixture

#We could force all  possible models to be included in the mixture
crime.Bvs.all<- Bvs(formula= y ~ ., data=UScrime, n.keep=2^15)
crime.Bvs.BMA<- BMAcoeff(crime.Bvs.all, n.sim=10000)
#(much slower as this implies ordering many more models...)

#With the Gibbs algorithms:
data(Ozone35)

Oz35.GibbsBvs<- GibbsBvs(formula= y ~ ., data=Ozone35, prior.betas="gZellner",
prior.models="Constant", n.iter=10000, init.model="Full", n.burnin=100,
time.test = FALSE)
Oz35.GibbsBvs.BMA<- BMAcoeff(Oz35.GibbsBvs, n.sim=10000)


}

}
\seealso{
See \code{\link[BayesVarSel]{histBMA}} for a histogram-like
representation of the columns in the object. See
\code{\link[BayesVarSel]{Bvs}} and
\code{\link[BayesVarSel]{GibbsBvs}} for creating objects of the class
\code{Bvs}. See \code{\link[mvtnorm]{rmvnorm} for details about argument
method.}
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

Maintainer: <anabel.forte@uv.es>
}
