% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_utils.R
\name{GLMEM_fixptseparate}
\alias{GLMEM_fixptseparate}
\title{Fixed point function for the joint BayesGLMEM update algorithm}
\usage{
GLMEM_fixptseparate(theta, spde, model_data, Psi, K, A, cl, Ns = 50)
}
\arguments{
\item{theta}{a list containing kappa2, phi, and sigma2, in that order}

\item{spde}{the spde object}

\item{model_data}{the model_data object containing \code{y} and \code{X}}

\item{Psi}{a conversion matrix (N by V) (or N by n)}

\item{K}{number of covariates}

\item{A}{The value for Matrix::crossprod(X\%*\%Psi) (saves time on computation)}

\item{cl}{parallelization cluster}

\item{Ns}{The number of samples used to approximate traces using the Hutchinson
estimator. If set to 0, the exact trace is found.}
}
\value{
a vector with the same length as \code{theta}, the EM updates
}
\description{
Fixed point function for the joint BayesGLMEM update algorithm
}
\keyword{internal}
