# h <-c(45,34,23,12,5,4) #paper
# f<-c(1,1, 14,15 ,16,17)
# NL<-135
# NI<-NL
# C=6
# dataList.high.ability <- list(f=f,h=h,NL=NL,NI=NI,C=C)
# devtools::use_data(dataList.high.ability)


# d1 <-get(data("dataList.Chakra.1"))
# d2 <-get(data("dataList.Chakra.2"))
# d3 <-get(data("dataList.Chakra.3"))
# d4 <-get(data("dataList.Chakra.4"))
# d.low <-get(data("dataList.low.ability"))
# d.high <-get(data("dataList.high.ability"))
#
#  par(new=F);viewdataSRSC(d4)
#  par(new=F);viewdataSRSC(d3)
#  par(new=F);viewdataSRSC(d2)
#  par(new=F);viewdataSRSC(d1)
#  par(new=F);viewdataSRSC(d.high)
#  par(new=F);viewdataSRSC(d.high)
#' @title  Build S4 classes with Drawing by "per lesion" model
#'
#'
#'@description  Build the S4 class by stan with your single reader
#'and single modality data \code{dataList}, with Drawing.
#'
#'
#'
#'@description The model is the author's Bayesian model introduced the author's paper.
#'@description  Before running the function \code{curve_srsc}, you should confirm
#'that your dataset is correctly formatted by the function \code{viewdataSRSC()}.
#'@inheritParams fit_Bayesian_FROC
#'@param dataList it should include  \code{f, h, NL, C}, note that the number of images \code{NI} is not necessary.
#'The detail of these dataset, please see the endowed datasets.
#'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
#' however,
#'\code{c } means the confidence level is not required, it is created by \code{  c <-c(rep(C:1))}, where \code{C} is the number of confidence levels.
#'So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.

#'So, to confirm
#'your false positives and hits are correctly correspondence
#'to confidence levels,
#'you should confirm the orders by the function


#'@param PreciseLogLikelihood  If \code{PreciseLogLikelihood} = TRUE, then Stan calculates the precise log likelihood.
#'
#'If \code{PreciseLogLikelihood} = FALSE, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.

#'@param DrawCurve This is a dichotomous, i.e., TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}. The reason why the author make this variable \code{DrawCurve} is that it take long time to draw curves, and thus default value is \code{FALSE}.


#'@param cha An argument of \code{rstan::stan}, which means the number of chains generated by Hamiltonian Monte Carlo method,
#'and, default = 4.
#'
#'
#'@param ite An argument of \code{rstan::stan}, which means the number of samples generated by Hamiltonian Monte Carlo method. If your model could not converge, then raise this number.
#' The default is 3000.


#'@param dig An argument of \code{rstan::stan}, which means the Significant digits, used in stan Cancellation.
#'The default is 3.
#'
#'
#'@param war An argument of \code{rstan::stan}, which means the Burn in period,
#' The default is 1000.
#'
#'@param see An argument of \code{rstan::stan}, which means a seed used in stan,
#'
#'
#' The default is 1234.
#'  If your model could not converge,
#' then change this number.
#'
#'
#'@return \code{stan.srsc.per.lesion}    This is S4 class!!
#'More precisely this is a S4 class, created by  \code{rstan::stan}.
#'
#'@return The stan S4 class object are build, named by \code{stan.srsc.per.lesion}.
#'
#'@return Using S4 class \code{stan.srsc.per.lesion}, you can go ahead to the next step,
#'that is, drawing the FROC curve and alternative FROC (AFROC) curves.
#'
#'
#'@examples
#' \donttest{
#'#First, we prepare the data endowed with this package.
#'
#'         dat  <- get(data("dataList.Chakra.1"))
#'
#'
#'
#'
#'#Second, we run the stan funtion
#'#with data named "dat"  and the author's Bayesian model.
#'
#'
#'          fit <-  fit_srsc_per_lesion(dat)
#'
#'
#'
#'
#'}# dottest

#' @import rstan
# @importFrom rstan stan
# devtools::document();help("curve_srsc_per_lesion") # Confirm reflection


#low AUC  converge
# war <- 5000 ;ite <- 10000;see <- 1234567  ;dig <- 5;cha <- 1;
# war <- 5000 ;ite <- 10000;see <- 1234568  ;dig <- 5;cha <- 1;
# war <- 5000 ;ite <- 10000;see <- 1234569  ;dig <- 5;cha <- 1;
#'@inheritParams fit_Bayesian_FROC
#' @export fit_srsc_per_lesion
#'@inheritParams DrawCurves_MRMC_pairwise

fit_srsc_per_lesion <- function(dataList,
                                DrawCurve = TRUE,
                                PreciseLogLikelihood = FALSE,
                                Drawcol = TRUE,
                                summary =TRUE,
                                make.csv.file.to.draw.curve=FALSE,
                                new.imaging.device=TRUE,

                                mesh.for.drawing.curve=10000,
                                DrawFROCcurve=TRUE,
                                DrawAFROCcurve=FALSE,
                                DrawCFPCTP=TRUE,
                                cha = 4,
                                ite = 3000,


                                dig = 5,
                                war = floor(ite/5),
                                see = 1234)
{
  message(" per lesion.\n")

  if(summary==TRUE) {  viewdata(dataList )}

  h <- dataList$h
  f <- dataList$f
  NL <- dataList$NL
  C  <- dataList$C
  c <-c(rep(C:1))
  data <- data.frame(Confidence_lebels=c,
                     True_Positives=h,
                     False_Positives=f)






  if (    (length(h) >length(f))
          || (length(h) <length(f))
  ) {  return(message("Format error:\nIn your data, true positive and false positives are not same length.\n"))
  } else
    if ( (sum(h) >NL) )
    {return(message("Format error:\nIn your data, number of true positives are greater than that of lesions.\n"))
    } else

      N <- length(f)
  # hh <- numeric(N) #cumulative fraction
  # ff <- numeric(N) #cumulative fraction
  # for(cd in 1:C) {
  #   for(n in 1:cd) {
  #     hh[cd]<-hh[cd]+h[n]/NL #cumulative fraction  to examine  the fitness of  FROC
  #     ff[cd]<-ff[cd]+f[n]/NL #cumulative fraction  to examine  the fitness of  FROC
  #   }}
  # fff <- numeric(N)
  # for(cd in 1:C) {
  #   for(n in 1:cd) {
  #     fff[cd]<-fff[cd]+f[n] #cumulative fraction  to examine  the fitness of  FROC
  #   }}


  fff <- cumsum(f)
  hh <- cumsum(h)/NL
  ff <- fff/NL



 hhh <-cumsum(h)#This is only for  the following table
 preCFP.preCTP <- data.frame(Cumulative.False.Positives=fff,Cumulative.True.Positives=hhh)
 CFP.CTP.dataframe <- data.frame(Cumulative.False.Positives.per.lesion=ff,Cumulative.True.Positives.per.lesion=hh)

 if(summary==TRUE) print(knitr::kable(preCFP.preCTP,format = "pandoc"))

 if(summary==TRUE) message("\n* By connecting the following points, we obtain the empirical FROC curve. \n")
 if(summary==TRUE) print(knitr::kable(CFP.CTP.dataframe,format = "pandoc"))
 if(summary==TRUE) message("\n*The above points are also called FPF(False Positive Fraction) and TPF(True Positive Fraction) . \n")

  # scr <- "Model_srsc_per_lesion.stan";
  if(PreciseLogLikelihood == FALSE  ){
    # scr <- "Model_srsc_per_lesion.stan";
    # scr <- base::system.file("extdata", "Model_srsc_per_lesion.stan", package="BayesianFROC")
    scr <-  system.file("extdata", "Model_srsc_per_lesion.stan", package="BayesianFROC")

  }else{
    if(PreciseLogLikelihood == TRUE  ){
      # scr <- "Model_srsc_per_lesion_target.stan";
      # scr <- base::system.file("extdata", "Model_srsc_per_lesion_target.stan", package="BayesianFROC")
      scr <-  system.file("extdata", "Model_srsc_per_lesion_target.stan", package="BayesianFROC")

    } else{
      message("PreciseLogLikelihood is allowed only two choice; TRUE or FALSE.")
    }}
  data <- list( N=N,NL=NL,C=C,c=c,h=h,f=f,hh=hh,ff=ff,fff=fff)
  rstan_options(auto_write = TRUE)
  initial <-c("m"=1,"v"=5,"w"=0,"dz"=1/2)

  scr <- rstan::stan_model(scr)# add
  # fit  <-  rstan::sampling(
  #                    object= scr, data=data,  verbose=F,
  #                    seed=see, chains=cha, warmup=war, iter=ite
  #                    , control = list(adapt_delta = 0.9999999,
  #                    max_treedepth = 15),init = initial
  #      )

  if (summary==FALSE) {


    invisible(utils::capture.output(
      fit  <-  rstan::sampling(
        object= scr, data=data,  verbose=F,
        seed=see, chains=cha, warmup=war, iter=ite
        , control = list(adapt_delta = 0.9999999,
                         max_treedepth = 15),init = initial
      )
    ))
  }#if


  if (summary==TRUE) {

    fit  <-  rstan::sampling(
      object= scr, data=data,  verbose=F,
      seed=see, chains=cha, warmup=war, iter=ite
      , control = list(adapt_delta = 0.9999999,
                       max_treedepth = 15),init = initial
    )

  }#if

  # fit  <- rstan::stan(file=scr, model_name=scr, data=data,  verbose=F,
  #                     seed=see, chains=cha, warmup=war, iter=ite)





  rstan::check_hmc_diagnostics(fit)
  check_rhat(fit)


  convergence <- ConfirmConvergence(fit,summary = summary)
  if(convergence ==FALSE){message("\n* So, model has no mean, we have to finish a calculation !!\n")

    fit.new.class <- methods::as(fit,"stanfitExtended")
    fit.new.class@metadata <-data
    fit.new.class@dataList <-dataList
    fit.new.class@studyDesign <-  "srsc.per.lesion"
    # if(PreciseLogLikelihood==TRUE) {fit.new.class@WAIC <- waic(fit,dig,summary=summary)}
    fit.new.class@convergence    <-  convergence
    # fit.new.class@chisquare <- chisquare
    fit.new.class@PreciseLogLikelihood    <-  PreciseLogLikelihood
    # fit.new.class@plotdata <-drawdata
    return(fit.new.class)
  }
  if(convergence ==TRUE){if(summary==TRUE)message("\n* We do not stop, since model cannot be said not converged.\n")}





  if(summary==T) {print(fit )}


  if(PreciseLogLikelihood == FALSE  ){
    if (summary==TRUE) {message("* WAIC was not caluculated, since log likelihoodis not a precise value.")}
  }else{
    if(PreciseLogLikelihood == TRUE  ){
      if (summary==TRUE) { message("* WAIC was caluculated, since log likelihoodis is a precise value, i.e., the traget += statement are used in the stan file.")}
      waic <-waic(fit,dig,summary=summary)
    } else{
      print("* PreciseLogLikelihood is allowed only two choice; TRUE or FALSE.")
    }}


  MCMC=(ite-war)*cha

  #Draw the  AFROC curve~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  set.seed(1);ll<- stats::rchisq(mesh.for.drawing.curve, 1)
  lll<- 0.99+ll
  l<-append(ll,lll)

  x<- 1-exp(-l) #AFROC
  y <-  array(0, dim=c(length(x)))



  a<-rstan::extract(fit)$a
  b<-rstan::extract(fit)$b
  EAP_a <-  array(0, dim=c(  MCMC))
  EAP_b <-  array(0, dim=c(  MCMC))
  EAP_a <- 0
  EAP_b <- 0
  s<-0
  t<-0
  for(mc in 1:MCMC){
    s<-  EAP_a
    EAP_a <-  s+ a[mc]
    t<-  EAP_b
    EAP_b <-  t+ b[mc]
  }
  EAP_a<-EAP_a/MCMC
  EAP_b<-EAP_b/MCMC

  # EAP_a<- fit@inits[[4]]$a
  # EAP_b<- fit@inits[[4]]$b

  #--------chi2 start--------------
  p<-rstan::extract(fit)$p
  lchi<-rstan::extract(fit)$l
  EAP_p <-  array(0, dim=c(   C))
  EAP_l <-  array(0, dim=c(   C+1))

  s <-  array(0, dim=c(   C))
  t <-  array(0, dim=c(   C+1))
  for(mc in 1:MCMC){
    for(cd in 1:C){
      s[ cd]<-  EAP_p[ cd]

      EAP_p[ cd] <-  s[ cd]+ p[mc,cd]
    }
    for(cd in 0:C){
      t[ cd]<-  EAP_l[ cd]
      EAP_l[ cd] <-  t[ cd]+ lchi[mc,cd]
    }
  }
  EAP_p<-EAP_p/MCMC
  EAP_l<-EAP_l/MCMC

  ss<-0
  tt<-0
  for(cd in 1:C){
    ss<-ss+(h[C+1-cd]-NL*EAP_p[cd])^2/(NL*EAP_p[cd])
    # tt<-(f[C+1-cd]-NI*(EAP_l[cd]-EAP_l[cd+1]))^2/(NI*(EAP_l[cd]-EAP_l[cd+1]))
    tt<-tt+(f[C+1-cd]-NL*(EAP_l[cd]-EAP_l[cd+1]))^2/(NL*(EAP_l[cd]-EAP_l[cd+1]))

  }
  chisquare <- ss+tt
  chisquare <- signif(chisquare,digits = dig)


  for(i in 1:length(x)){
    y[i]<-1-stats::pnorm(EAP_b*stats::qnorm(exp(-l[i]))-EAP_a)
  }

  if(DrawCurve == TRUE  ){
    if(PreciseLogLikelihood==TRUE){  title <- paste("Lesions = ",NL,", chi^2 =",chisquare, ", WAIC =",waic)}
    if(PreciseLogLikelihood==FALSE){  title <- paste("Lesions = ",NL,",  chi^2 =",chisquare)}

    if(  DrawFROCcurve == TRUE|| DrawCFPCTP==TRUE||DrawAFROCcurve==TRUE ){
      if (new.imaging.device==TRUE) {
        grDevices::dev.new()
      }
      }
    if( !( DrawFROCcurve == TRUE|| DrawCFPCTP==TRUE||DrawAFROCcurve==TRUE) ){
      if(summary==TRUE)message("\n* We do not draw anything according to your input.\n")
    }



    upper_x <- max(ff)
    upper_y <- 1.0
    graphics::par(lwd = 2 )
    suppressWarnings(graphics::par(new=TRUE));

    if(Drawcol==FALSE){
      if(DrawAFROCcurve==TRUE){
        suppressWarnings(graphics::par(new=T));plot(x,y,#AFROC
             xlim = c(0,upper_x),ylim = c(0,upper_y),
             col = 'black',
             cex=0.1,
             xlab = 'mean of cumulative false positives per lesion',
             ylab = 'cumulative hit per lesion'
        )
      }
      if(DrawFROCcurve==TRUE){
        suppressWarnings(graphics::par(new=T));
        plot(l,y,
             xlim = c(0,upper_x),ylim = c(0,upper_y),
             cex=1,
             col = 'black',
             xlab = '', ylab = '')
      }
      if(DrawCFPCTP==TRUE){
        suppressWarnings(graphics::par(new=T));plot(ff,hh,cex=3,
                                                     xlim = c(0,upper_x),ylim = c(0,upper_y),col = 'black', xlab = '', ylab = '')

      }
    }


    if(Drawcol==TRUE){

      graphics::par(bg= "gray12", #"gray27",#"gray40",#"black",# ,
                    fg="gray",
                    col.lab="bisque2" ,#"bisque" ,#  "antiquewhite1",
                    col.axis="bisque2" ,##"bisque" "antiquewhite1",
                    col.main="bisque2" ,
                    cex.lab=1.5,
                    cex.axis=1.3
      )
    }
    if(DrawAFROCcurve==TRUE){

      suppressWarnings(graphics::par(new=T)); plot(x,y,
                                      col ="antiquewhite1",
                                      cex= 0.1 ,
                                      xlim = c(0,upper_x ),ylim = c(0,upper_y),
                                      xlab = 'mean of false positives per lesion',
                                      ylab = 'cumulative hit per lesion'
                                      ,main =title
      );
      # message("\n * In the plot plane, the AFROC curves emanate from origin (0,0) to (1,1).\n")
    }

    if(DrawFROCcurve==TRUE){


      #FROC
      suppressWarnings(graphics::par(new=T)); plot(l,y,
                                      col ="antiquewhite1",
                                      bg="gray",
                                      fg="gray",
                                      xlab = 'mean of false positives per lesion',
                                      ylab = 'cumulative hit per lesion',
                                      cex= 0.1,
                                      xlim = c(0,upper_x ),
                                      ylim = c(0,upper_y)
                                      ,main =title

      );

    }


    if(DrawCFPCTP==TRUE){

      #CFP-CTP points
      # pchh <-paste(md);
      suppressWarnings(graphics::par(new=T));plot(ff,hh,
                                                   xlim = c(0,upper_x ),
                                                   ylim = c(0,upper_y),
                                                   # col =1+(md-1)*Q+(qd-1),
                                                   # col =rgb(1/md,1/md,1/md),
                                                   bg="gray",
                                                   fg="gray",
                                                   col ="antiquewhite1",
                                                   # pch =paste(md),
                                                   cex=3,# Size of Dots
                                                   xlab = '', ylab = '')
    }
  }# <---if(Drawcol==TRUE)
























  if(DrawCurve == FALSE && summary==TRUE  ){
    message(" \n We de not draw the FROC and AFROC curves. \n")
  }

  if(DrawCurve == FALSE||DrawCurve == TRUE){
   if (summary==TRUE) {
     message(" \n DrawCurve is allowed only two choice; TRUE or FALSE. \n")
  }}










  if(summary ==TRUE){

    paste <- paste("The goodness of fit chi-square statistic is equal to ", signif( chisquare,digits = dig)," \n")
    message("\n--------------------------------------------------  \n")
    message(paste)
    message("--------------------------------------------------  \n")
    message("\n The expected a posterior estimate of the area under the FROC curve: \n \n ")
    pasteAUC <- paste("AUC =  ",  summary(fit)$summary["A","mean"], " \n" )
    message(pasteAUC)

    message("\n--------------------------------------------------  \n")

    pasteAUC.CI <- paste("The 95%CI = [", summary(fit)$summary["A","2.5%"], ",",summary(fit)$summary["A","97.5%"], "]." )
    message("\n The 95% credible interval of AUC := [ lower bound, upper bound] \n \n ")

    message(pasteAUC.CI)
    message("\n--------------------------------------------------  \n")
    message("\n* The column of mean shows the expected a posterior (EAP) estimates for you data. \n")
    message("\n* The column of 2.5% shows the lower bound of  95% credible interval  for each parameter with respect to you data. \n")
    message("\n* The column of 97.5% shows the upper bound of 95% credible interval for each parameter with respect to you data. \n")
  }





  fit.new.class <- methods::as(fit,"stanfitExtended")
  fit.new.class@metadata <-data
  fit.new.class@dataList <-dataList
  fit.new.class@studyDesign <-  "srsc.per.lesion"
  if(PreciseLogLikelihood==TRUE) {fit.new.class@WAIC <- waic(fit,dig,summary=FALSE)}
  fit.new.class@convergence    <-  convergence
  fit.new.class@PreciseLogLikelihood    <-  PreciseLogLikelihood
  fit.new.class@chisquare <- chisquare

  if(summary ==TRUE){
    summary_EAP_CI_srsc(
      StanS4class=fit.new.class,
      dig=dig
    )
  }#if

  drawdata <- data.frame(x.AFROC =x,
                         y.AFROC=y,
                         x.FROC= l,
                         y.FROC=y )
  if(make.csv.file.to.draw.curve==TRUE){
    #Launch the Draw data---START
    message("\n\n* Please wait ... now we launch two scv files to draw your FROC curve and cumulative hits and false alarms")
    xlsx::write.xlsx (drawdata, paste(file.path(Sys.getenv("USERPROFILE"),"Desktop"),"/DrawData.xlsx", sep = ""),  col.names=TRUE, row.names=FALSE, append=FALSE, showNA=TRUE)
    message("* A DrawData.csv are created in your desktop. \n* Using this csv file, you can draw the FROC and AFROC curves by scatter plot.")
    drawTPFP <- data.frame(NumberOfCumulativeFalsePositives =ff,
                           NumberOfCumulativeTurePositives=hh)
    xlsx::write.xlsx (drawTPFP, paste(file.path(Sys.getenv("USERPROFILE"),"Desktop"),"/DrawPoints.xlsx",  sep = ""),col.names=TRUE, row.names=FALSE, append=FALSE, showNA=TRUE)
    message("\n* A DrawPoints.csv are created in your desktop. \n")
    message("\n* Using this csv file you can plot cumlative false positives and cumulative true positives by scatter plot.")
  }
  #Launch the Draw data---STOP
  fit.new.class@plotdata <-drawdata

  extractAUC(
    StanS4class=fit.new.class,
    summary=summary,
    dig=dig
  )


  if(summary ==TRUE){size_of_return_value(summary=summary,object =  fit.new.class)}
  fit.new.class@Divergences      <- sum(rstan::get_divergent_iterations(fit))
  fit.new.class@MCMC.Iterations       <- length(rstan::get_divergent_iterations(fit))
  fit.new.class@Divergence.rate  <- 100*sum(rstan::get_divergent_iterations(fit))/length(rstan::get_divergent_iterations(fit))



  invisible(fit.new.class)



}





