% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Based_Calibration.R
\name{Draw_a_simulated_data_set}
\alias{Draw_a_simulated_data_set}
\title{Draw a simulated dataset from model distributions with specified parameters from priors}
\usage{
Draw_a_simulated_data_set(sd = 5, C = 5,
  seed.for.drawing.a.prior.sample = 1111, fun = stats::var, NI = 259,
  NL = 259, initial.seed.for.drawing.a.data = 1234,
  ModifiedPoisson = FALSE, ite = 1111)
}
\arguments{
\item{sd}{Standard Deviation of priors}

\item{C}{No. of Confidence levels}

\item{seed.for.drawing.a.prior.sample}{seed}

\item{fun}{An one dimensional real valued function defined on the parameter space. This is used in the definition of the rank statistics. Generally speaking, the element of the parameter space is a vector, so the function should be defined on vectors. In my model parameter is mean, standard deviation, C thresholds of the latent Gaussian, so this function should be defined on the C+2 dimensional Euclidean space.}

\item{NI}{No. of images}

\item{NL}{No. of Lesions}

\item{initial.seed.for.drawing.a.data}{seed}

\item{ModifiedPoisson}{This is dichotomous, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm are \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm are \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.}

\item{ite}{An argument of \code{rstan::stan()} in which it is named \code{iter}.  It means the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number.}
}
\value{
One simulated dataset
}
\description{
Draw a simulated dataset from model distributions with specified parameters from priors
}
\examples{

\donttest{
   one.dataList  <-  Draw_a_simulated_data_set()

}# dottest
}
