% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data_frame_from_dataList_MRMC.R
\name{extract_data_frame_from_dataList_MRMC}
\alias{extract_data_frame_from_dataList_MRMC}
\title{Extract sub data frame from list of FROC data}
\usage{
extract_data_frame_from_dataList_MRMC(dataList, verbose = FALSE)
}
\arguments{
\item{dataList}{A list of MRMC data.}

\item{verbose}{A logical, if \code{TRUE}, then the redundant summary is printed in \R console.
If \code{FALSE}, it suppresses output from this function.}
}
\value{
A data frame consisting of  vectors \code{m,q,c,h,f}.
\describe{
\item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}}.   }
\item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarms}}.  }
}
}
\description{
Makes a dataframe
 from a list consisting of  vectors \code{m,q,c,h,f} and positive integers \code{NL,C,M,Q,NI}.
 The resulting data-frame is construceted by  vectors \code{m,q,c,h,f}.
}
\examples{
\dontrun{


#========================================================================================
#                      From example dataset named dddddd
#========================================================================================

## Only run examples in interactive R sessions
if (interactive()) {

 fit_GUI_Shiny_MRMC(DF=extract_data_frame_from_dataList_MRMC(dddddd))


}## Only run examples in interactive R sessions


}

}
