% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_na_list.R
\name{is_na_list}
\alias{is_na_list}
\title{Check whether a list contains NA or not.}
\usage{
is_na_list(alist)
}
\arguments{
\item{alist}{A list constructed by numeric vectors, which possibly contained in NAs.}
}
\value{
A logical, if list contains NA, then TRUE. And False for the others.
}
\description{
Check whether a list contains NA or not.
}
\examples{

#========================================================================================
#   If a list does not contain NAs, then return TRUE
#========================================================================================

#'d <- list(a=c(1,1),aa = c(2,2),aaa =c(3,3,3))
is_na_list(d)








#========================================================================================
#   If a list contains NAs, then return TRUE
#========================================================================================

d <- list(a=c(NA,1),aa = c(2,2),aaa =c(3,3,3))
is_na_list(d)





#========================================================================================
#   Note that a data frame is a list of equal-length vectors
#========================================================================================

d <- is_na_list(data.frame(c(1,1)))
is_na_list(d)


d <- is_na_list(data.frame(c(1,NA)))
is_na_list(d)








}
