% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFROC.R
\name{plotFROC}
\alias{plotFROC}
\title{Draw FROC curves by two parameters a and b}
\usage{
plotFROC(
  a,
  b,
  mesh.for.drawing.curve = 10000,
  upper_x = 1,
  upper_y = 1,
  lower_y = 0
)
}
\arguments{
\item{a}{An arbitrary real number.
It is no need to require any assumption,
but I use such as \code{a}=\eqn{\mu/\sigma},
where \eqn{\mu} is a mean of signal distribution and \eqn{\sigma} is its standard deviation in the bi-normal assumption.}

\item{b}{An arbitrary positive real number.
I use such as \code{b}=\eqn{1/\sigma},
where \eqn{\sigma} is a standard deviation of signal distribution in the bi-noraml assumption.}

\item{mesh.for.drawing.curve}{A positive large integer, indicating number of dots drawing the curves, Default =10000.}

\item{upper_x}{A positive real number, indicating the frame size of drawing picture.}

\item{upper_y}{A positive real number, indicating the frame size of drawing picture.}

\item{lower_y}{A positive real number, indicating the frame size of drawing picture.}
}
\description{
Plot FROC curves based on two parameters a and b.
}
\details{
FROC curve is the alternative notion of ROC curve in signal detection theory.


The definition of FROC curve is

  \deqn{(x(t),y(t) ) = (t,   1 - \Phi(  b* \Phi^{-1}(exp(-t)) -a  )  ) }


where, \eqn{\Phi()} is the cumulative distribution
function of the standard Gaussian distribution and
\eqn{\Phi^{-1}()} is its inverse mapping.

Revised 2019 NOv 27
}
\examples{

dark_theme()

plotFROC(0.1,0.2)

}
