% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMCPMod.R
\name{performBayesianMCPMod}
\alias{performBayesianMCPMod}
\title{performBayesianMCPMod}
\usage{
performBayesianMCPMod(posterior_list, contr, crit_prob_adj, simple = FALSE)
}
\arguments{
\item{posterior_list}{An object of class 'postList' as created by getPosterior() containing information about the (mixture) posterior distribution per dose group}

\item{contr}{An object of class 'optContr' as created by the getContr() function. It contains the contrast matrix to be used for the testing step.}

\item{crit_prob_adj}{A getCritProb object, specifying the critical value to be used for the testing (on the probability scale).}

\item{simple}{Boolean variable, defining whether simplified fit will be applied. Passed to the getModelFits() function. Default FALSE.}
}
\value{
Bayesian MCP test result as well as modeling result.
}
\description{
Performs Bayesian MCP Test step and modeling in a combined fashion. See performBayesianMCP() function for MCP Test step and getModelFits() for the modeling step
}
\examples{
mods <- DoseFinding::Mods(linear      = NULL,
                          linlog      = NULL,
                          emax        = c(0.5, 1.2),
                          exponential = 2,
                          doses       = c(0, 0.5, 2,4, 8))
dose_levels  <- c(0, 0.5, 2, 4, 8)
sd_posterior <- c(2.8, 3, 2.5, 3.5, 4)
contr_mat <- getContr(
  mods         = mods,
  dose_levels  = dose_levels,
  sd_posterior = sd_posterior)
critVal <- getCritProb(
  mods           = mods,
  dose_weights   = c(50, 50, 50, 50, 50), #reflecting the planned sample size
  dose_levels    = dose_levels,
  alpha_crit_val = 0.05)
prior_list <- list(Ctrl = RBesT::mixnorm(comp1 = c(w = 1, m = 0, s = 5), sigma = 2),
                   DG_1 = RBesT::mixnorm(comp1 = c(w = 1, m = 1, s = 12), sigma = 2),
                   DG_2 = RBesT::mixnorm(comp1 = c(w = 1, m = 1.2, s = 11), sigma = 2) ,
                   DG_3 = RBesT::mixnorm(comp1 = c(w = 1, m = 1.3, s = 11), sigma = 2) ,
                   DG_4 = RBesT::mixnorm(comp1 = c(w = 1, m = 2, s = 13), sigma = 2))
mu <- c(0, 1, 1.5, 2, 2.5)
S_hat <- c(5, 4, 6, 7, 8)
posterior_list <- getPosterior(
  prior_list = prior_list,
  mu_hat     = mu,
  S_hat     = S_hat)
performBayesianMCPMod(posterior_list = posterior_list,
                      contr          = contr_mat,
                      crit_prob_adj  = critVal,
                      simple         = FALSE)

}
