% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bayes_error}
\alias{bayes_error}
\title{Determine the unconditional error probabilities for a set of simulated
Bayes factors.}
\usage{
bayes_error(BFs1, BFs2, bound1 = 1, bound2 = 1/bound1)
}
\arguments{
\item{BFs1}{A vector. Simulated BF12 under H1 for a given n}

\item{BFs2}{A vector. Simulated BF12 under H2 for a given n}

\item{bound1}{A number. The boundary above which BF12 favors H1}

\item{bound2}{A number. The boundary below which BF12 favors H2}
}
\value{
A named vector. The Type 1, Type 2, Decision error and Area of Indecision probabilities
and the median Bayes factors under H1 and H2
}
\description{
Determine the unconditional error probabilities for a set of simulated
Bayes factors.
}
