% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianTools.R
\docType{package}
\name{BayesianTools}
\alias{BayesianTools}
\alias{BayesianTools-package}
\title{BayesianTools}
\description{
A package with general-purpose MCMC and SMC samplers,  as well as plots and diagnostic functions for Bayesian statistics
}
\details{
A package with  general-purpose MCMC and SMC samplers, as well as plots and diagnostic functions for Bayesian statistics, particularly for process-based models. 

The package contains 2 central functions, \code{\link{createBayesianSetup}}, which creates a standardized Bayesian setup with likelihood and priors, and \code{\link{runMCMC}}, which allows to run various MCMC and SMC samplers.

The package can of course also be used for general (non-Bayesian) target functions. 

To use the package, a first step to use \code{\link{createBayesianSetup}} to create a BayesianSetup, which usually contains prior and likelihood densities, or in general a target function. 

Those can be sampled with \code{\link{runMCMC}}, which can call a number of general purpose Metropolis sampler, including the \code{\link{Metropolis}} that allows to specify various popular Metropolis variants such as adaptive and/or delayed rejection Metropolis; two variants of differential evolution MCMC \code{\link{DE}}, \code{\link{DEzs}}, two variants of DREAM  \code{\link{DREAM}} and \code{\link{DREAMzs}}, the \code{\link{Twalk}} MCMC, and a Sequential Monte Carlo sampler \code{\link{smcSampler}}. 

The output of runMCMC is of class mcmcSampler / smcSampler if one run is performed, or mcmcSamplerList / smcSamplerList if several sampler are run. Various functions are available for plotting, model comparison (DIC, marginal likelihood), or to use the output as a new prior.  

For details on how to use the packgage, run vignette("BayesianTools", package="BayesianTools").

Acknowledgements: The creation of this package was facilicated through meetings of Cost Action FP 1304 Profound.
}
