/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class ExponentialSawtooth
extends ExponentialGrowth {
    private double wavelength;
    private double offset;

    public ExponentialSawtooth(Units.Type type) {
        super(type);
    }

    public final double getWavelength() {
        return this.wavelength;
    }

    public final void setWavelength(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.wavelength = d;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void setOffset(double d) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.offset = d;
    }

    @Override
    public double getDemographic(double d) {
        int n = (int)Math.floor((d += this.offset * this.wavelength) / this.wavelength);
        return super.getDemographic(d -= (double)n * this.wavelength);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.offset * this.wavelength;
        if (d < this.wavelength - d2) {
            return super.getIntensity(d + d2) - super.getIntensity(d2);
        }
        double d3 = super.getIntensity(this.wavelength) - super.getIntensity(d2);
        int n = (int)Math.floor((d -= this.wavelength - d2) / this.wavelength);
        d3 += (double)n * super.getIntensity(this.wavelength);
        return d3 += super.getIntensity(d -= (double)n * this.wavelength);
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "wavelength";
            }
            case 3: {
                return "offset";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getWavelength();
            }
            case 3: {
                return this.getOffset();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setWavelength(d);
                break;
            }
            case 3: {
                this.setOffset(d);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public DemographicFunction getCopy() {
        ExponentialSawtooth exponentialSawtooth = new ExponentialSawtooth(this.getUnits());
        exponentialSawtooth.setN0(this.getN0());
        exponentialSawtooth.setGrowthRate(this.getGrowthRate());
        exponentialSawtooth.setWavelength(this.getWavelength());
        exponentialSawtooth.setOffset(this.getOffset());
        return exponentialSawtooth;
    }

    public static void main(String[] stringArray) {
        double d = Double.parseDouble(stringArray[0]);
        double d2 = Double.parseDouble(stringArray[1]);
        double d3 = Double.parseDouble(stringArray[2]);
        double d4 = Double.parseDouble(stringArray[3]);
        ExponentialSawtooth exponentialSawtooth = new ExponentialSawtooth(Units.Type.SUBSTITUTIONS);
        exponentialSawtooth.setN0(d);
        exponentialSawtooth.setGrowthRate(d2);
        exponentialSawtooth.setWavelength(d3);
        exponentialSawtooth.setOffset(d4);
        for (double d5 = 0.0; d5 < 20.0; d5 += 0.1) {
            System.out.println(d5 + "\t" + exponentialSawtooth.getDemographic(d5) + "\t" + exponentialSawtooth.getIntensity(d5));
        }
    }
}

