/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.sequence;

import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.SequenceList;
import dr.evolution.util.Taxon;
import dr.util.Attributable;
import dr.util.Identifiable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Sequences
implements SequenceList,
Attributable,
Identifiable {
    protected String id = null;
    protected final Vector<Sequence> sequences = new Vector();
    private Attributable.AttributeHelper attributes = null;

    @Override
    public int getSequenceCount() {
        return this.sequences.size();
    }

    @Override
    public Sequence getSequence(int n) {
        return this.sequences.get(n);
    }

    @Override
    public void setSequenceAttribute(int n, String string, Object object) {
        Sequence sequence = this.getSequence(n);
        sequence.setAttribute(string, object);
    }

    @Override
    public Object getSequenceAttribute(int n, String string) {
        Sequence sequence = this.getSequence(n);
        return sequence.getAttribute(string);
    }

    @Override
    public int getTaxonCount() {
        return this.getSequenceCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.getSequence(n).getTaxon();
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        throw new IllegalArgumentException("Illegal taxon index:" + n);
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    public void setTaxonAttribute(int n, String string, Object object) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            taxon.setAttribute(string, object);
        } else {
            this.setSequenceAttribute(n, string, object);
        }
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return this.getSequenceAttribute(n, string);
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < Sequences.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return Sequences.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void insertSequence(int n, Sequence sequence) {
        this.sequences.insertElementAt(sequence, n);
    }

    public Sequence removeSequence(int n) {
        Sequence sequence = this.getSequence(n);
        this.sequences.removeElementAt(n);
        return sequence;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }
}

