/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.alloppnet.speciation.BirthDeathCollapseModel;
import dr.evoxml.util.XMLUnits;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class BirthDeathCollapseModelParser
extends AbstractXMLObjectParser {
    public static final String BIRTH_DEATH_COLLAPSE_MODEL = "birthDeathCollapseModel";
    public static final String COLLAPSE_HEIGHT = "collapseHeight";
    public static final String TREE = "speciesTree";
    public static final String BIRTHDIFF_RATE = "birthMinusDeathRate";
    public static final String RELATIVE_DEATH_RATE = "relativeDeathRate";
    public static final String ORIGIN_HEIGHT = "originHeight";
    public static final String COLLAPSE_WEIGHT = "collapseWeight";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("speciesTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)}), new ElementRule("birthMinusDeathRate", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("relativeDeathRate", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("originHeight", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("collapseWeight", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), XMLUnits.SYNTAX_RULES[0], AttributeRule.newDoubleRule("collapseHeight")};

    @Override
    public String getParserName() {
        return BIRTH_DEATH_COLLAPSE_MODEL;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
        double d = xMLObject.getDoubleAttribute(COLLAPSE_HEIGHT);
        XMLObject xMLObject2 = xMLObject.getChild(TREE);
        Tree tree = (Tree)xMLObject2.getChild(Tree.class);
        Parameter parameter = (Parameter)xMLObject.getElementFirstChild(BIRTHDIFF_RATE);
        Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(RELATIVE_DEATH_RATE);
        Parameter parameter3 = (Parameter)xMLObject.getElementFirstChild(ORIGIN_HEIGHT);
        Parameter parameter4 = (Parameter)xMLObject.getElementFirstChild(COLLAPSE_WEIGHT);
        String string = xMLObject.getId();
        return new BirthDeathCollapseModel(string, tree, type, parameter, parameter2, parameter3, parameter4, d);
    }

    @Override
    public Class getReturnType() {
        return BirthDeathCollapseModel.class;
    }

    @Override
    public String getParserDescription() {
        return "A speciation model aimed at species delimitation, mixing birth-death model with spike near zero for node heights.";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

