/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import cern.jet.math.Bessel;

public class ModifiedBesselFirstKind {
    public static final int ACC = 40;
    public static final double BIGNO = 1.0E10;
    public static final double BIGNI = 1.0E-10;

    public static double bessi(double d, int n) {
        if (n == 0) {
            return Bessel.i0(d);
        }
        if (n == 1) {
            return Bessel.i1(d);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 2.0 / Math.abs(d);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        for (int i = 2 * (n + (int)Math.sqrt(40 * n)); i > 0; --i) {
            double d6 = d4 + (double)i * d2 * d5;
            d4 = d5;
            d5 = d6;
            if (Math.abs(d5) > 1.0E10) {
                d3 *= 1.0E-10;
                d5 *= 1.0E-10;
                d4 *= 1.0E-10;
            }
            if (i != n) continue;
            d3 = d4;
        }
        return d < 0.0 && (n & 1) != 0 ? -d3 : (d3 *= Bessel.i0(d) / d5);
    }
}

