/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class ExponentialGrowth
extends ConstantPopulation {
    private double r;

    public ExponentialGrowth(Units.Type type) {
        super(type);
    }

    public final double getGrowthRate() {
        return this.r;
    }

    public void setGrowthRate(double d) {
        this.r = d;
    }

    public void setDoublingTime(double d) {
        this.setGrowthRate(Math.log(2.0) / d);
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return this.getN0();
        }
        return this.getN0() * Math.exp(-d * d2);
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getGrowthRate();
        if (d3 == 0.0) {
            return (d2 - d) / this.getN0();
        }
        return (Math.exp(d2 * d3) - Math.exp(d * d3)) / this.getN0() / d3;
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return d / this.getN0();
        }
        return (Math.exp(d * d2) - 1.0) / this.getN0() / d2;
    }

    @Override
    public double getIntensityGradient(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return 1.0 / this.getN0();
        }
        return Math.exp(d * d2) / this.getN0();
    }

    @Override
    public double getLogDemographicGradient(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return 0.0;
        }
        return -d2;
    }

    @Override
    public double getInverseIntensity(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return this.getN0() * d;
        }
        return Math.log(1.0 + this.getN0() * d * d2) / d2;
    }

    @Override
    public int getNumArguments() {
        return 2;
    }

    @Override
    public String getArgumentName(int n) {
        if (n == 0) {
            return "N0";
        }
        return "r";
    }

    @Override
    public double getArgument(int n) {
        if (n == 0) {
            return this.getN0();
        }
        return this.getGrowthRate();
    }

    @Override
    public void setArgument(int n, double d) {
        if (n == 0) {
            this.setN0(d);
        } else {
            this.setGrowthRate(d);
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public DemographicFunction getCopy() {
        ExponentialGrowth exponentialGrowth = new ExponentialGrowth(this.getUnits());
        exponentialGrowth.setN0(this.getN0());
        exponentialGrowth.r = this.r;
        return exponentialGrowth;
    }
}

